/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
public final class ExtendedInnerCornerSlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstLargeCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstExtendedSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstVerticalStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> ExtendedInnerCornerSlopePanelSkipPredicate.testAgainstVerticalHalfStairs(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (ExtendedInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(ExtendedInnerCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return true;
        }
        return ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(LargeCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(LargeInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return ExtendedInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(ExtendedCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return ExtendedInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return ExtendedInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedInnerSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return ExtendedInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatExtendedInnerSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        return ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        return ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean top, Direction side) {
        Direction dirTwo;
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == dir) {
            return HalfTriangleDir.fromDirections(dir.m_122427_(), dirTwo, false);
        }
        if (side == dir.m_122428_()) {
            return HalfTriangleDir.fromDirections(dir.m_122424_(), dirTwo, false);
        }
        return HalfTriangleDir.NULL;
    }

    public static TriangleDir getStairDir(Direction dir, boolean top, Direction side) {
        if (!top && side == Direction.UP || top && side == Direction.DOWN) {
            return TriangleDir.fromDirections(dir.m_122424_(), dir.m_122427_());
        }
        return TriangleDir.NULL;
    }
}

