/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.resourcepackcached.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachingUtils {
    public static final File GAME_DIR = FMLPaths.GAMEDIR.get().toFile();
    public static final File CACHE_FILE = new File(GAME_DIR, "rpc-data.json");
    public static final Logger LOGGER = LogManager.getLogger(CachingUtils.class);

    public static void writeCacheFile(Map<UUID, Path> packs) {
        try {
            JsonObject jsonObject = new JsonObject();
            JsonArray packsArray = new JsonArray();
            for (Map.Entry<UUID, Path> entry : packs.entrySet()) {
                if (!Files.exists(entry.getValue(), new LinkOption[0])) continue;
                JsonObject packObject = new JsonObject();
                packObject.addProperty("uuid", entry.getKey().toString());
                packObject.addProperty("path", entry.getValue().toString());
                packsArray.add((JsonElement)packObject);
            }
            jsonObject.add("packs", (JsonElement)packsArray);
            FileUtils.writeStringToFile((File)CACHE_FILE, (String)jsonObject.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write cache file", (Throwable)e);
        }
    }

    public static Map<UUID, Path> readCacheFile() {
        HashMap<UUID, Path> packs = new HashMap<UUID, Path>();
        if (CACHE_FILE.exists()) {
            try {
                JsonObject jsonObject;
                JsonArray packsArray;
                String content = FileUtils.readFileToString((File)CACHE_FILE, (Charset)StandardCharsets.UTF_8);
                if (!content.isEmpty() && (packsArray = (jsonObject = JsonParser.parseString((String)content).getAsJsonObject()).getAsJsonArray("packs")) != null) {
                    for (int i = 0; i < packsArray.size(); ++i) {
                        JsonObject packObject = packsArray.get(i).getAsJsonObject();
                        UUID uuid = UUID.fromString(packObject.get("uuid").getAsString());
                        Path path = Paths.get(packObject.get("path").getAsString(), new String[0]);
                        if (!Files.exists(path, new LinkOption[0])) continue;
                        packs.put(uuid, path);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read cache file", (Throwable)e);
            }
        }
        return packs;
    }
}

