/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.resourcepackcached.mixin;

import dev.furq.resourcepackcached.utils.CachingUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DownloadedPackSource;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DownloadedPackSource.class})
abstract class DownloadedPackSourceMixin {
    @Shadow
    @Final
    private static Component f_243792_;
    @Shadow
    @Final
    private static Logger f_243667_;
    @Unique
    private static boolean isInitializing;
    @Shadow
    @Nullable
    private Pack f_244082_;
    @Shadow
    @Nullable
    private CompletableFuture<?> f_243680_;
    @Shadow
    @Final
    private ReentrantLock f_244572_;

    DownloadedPackSourceMixin() {
    }

    @Inject(method={"clearServerPack"}, at={@At(value="HEAD")}, cancellable=true)
    public void onClearServerPack(CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        CompletableFuture<Object> completablefuture;
        this.f_244572_.lock();
        try {
            if (this.f_243680_ != null) {
                this.f_243680_.cancel(true);
            }
            this.f_243680_ = null;
            completablefuture = CompletableFuture.completedFuture(null);
        }
        finally {
            this.f_244572_.unlock();
        }
        cir.setReturnValue(completablefuture);
    }

    @Inject(method={"setServerPack"}, at={@At(value="HEAD")}, cancellable=true)
    public void onSetServerPack(File file, PackSource packSource, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        Pack.ResourcesSupplier resourcesSupplier = string -> new FilePackResources(string, file, false);
        Pack.Info info = Pack.m_246334_((String)"server", (Pack.ResourcesSupplier)resourcesSupplier);
        if (info == null) {
            f_243667_.error("Invalid pack metadata at {}", (Object)file);
            cir.setReturnValue(CompletableFuture.failedFuture(new IllegalArgumentException("Invalid pack metadata at " + String.valueOf(file))));
        } else {
            f_243667_.info("Applying server pack {}", (Object)file);
            Pack newServerPack = Pack.m_245512_((String)"server", (Component)f_243792_, (boolean)true, (Pack.ResourcesSupplier)resourcesSupplier, (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)true, (PackSource)packSource);
            Map<UUID, Path> cachedPacks = CachingUtils.readCacheFile();
            UUID SUBSTITUTE_UUID = UUID.fromString("b700a6a9-58e1-4e5b-a995-ead5edc8f72a");
            Path resourcePack = cachedPacks.get(SUBSTITUTE_UUID);
            CompletableFuture returnValue = null;
            if (resourcePack == null || isInitializing) {
                cachedPacks.put(SUBSTITUTE_UUID, file.toPath());
                CachingUtils.writeCacheFile(cachedPacks);
                this.f_244082_ = newServerPack;
                returnValue = Minecraft.m_91087_().m_91088_();
            } else if (this.f_244082_ != null || !file.equals(resourcePack.toFile())) {
                this.f_244082_ = newServerPack;
                if (!file.equals(resourcePack.toFile())) {
                    cachedPacks.put(SUBSTITUTE_UUID, file.toPath());
                    CachingUtils.writeCacheFile(cachedPacks);
                    returnValue = Minecraft.m_91087_().m_91088_();
                }
            }
            if (returnValue == null) {
                returnValue = CompletableFuture.completedFuture(null);
            }
            isInitializing = false;
            cir.setReturnValue(returnValue);
        }
    }

    static {
        isInitializing = true;
    }
}

