/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic.entityblocking;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.village.VillageSiegeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.logic.entityblocking.LightsRegistryCapability;

@Mod.EventBusSubscriber(modid="torchmaster")
public class EntityBlockingEventHandler {
    private static boolean isIntentionalSpawn(MobSpawnType spawnType) {
        switch (spawnType) {
            case BREEDING: 
            case DISPENSER: 
            case BUCKET: 
            case CONVERSION: 
            case SPAWN_EGG: 
            case TRIGGERED: 
            case COMMAND: 
            case EVENT: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNaturalSpawn(MobSpawnType spawnType) {
        switch (spawnType) {
            default: {
                return true;
            }
            case BREEDING: 
            case DISPENSER: 
            case BUCKET: 
            case CONVERSION: 
            case SPAWN_EGG: 
            case TRIGGERED: 
            case COMMAND: 
            case EVENT: 
            case SPAWNER: 
            case STRUCTURE: 
            case MOB_SUMMONED: 
            case REINFORCEMENT: 
            case JOCKEY: 
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        BlockPos pos;
        boolean log = (Boolean)TorchmasterConfig.GENERAL.logSpawnChecks.get();
        if (log) {
            Torchmaster.Log.debug("CheckSpawn - SpawnType: {}, EntityType: {}, Pos: {}/{}/{}", new Object[]{event.getSpawnType(), EntityType.m_20613_((EntityType)event.getEntity().m_6095_()), event.getX(), event.getY(), event.getZ()});
        }
        if (event.isSpawnCancelled()) {
            return;
        }
        if (EntityBlockingEventHandler.isIntentionalSpawn(event.getSpawnType())) {
            return;
        }
        if (!((Boolean)TorchmasterConfig.GENERAL.aggressiveSpawnChecks.get()).booleanValue() && event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (((Boolean)TorchmasterConfig.GENERAL.blockOnlyNaturalSpawns.get()).booleanValue() && !EntityBlockingEventHandler.isNaturalSpawn(event.getSpawnType())) {
            return;
        }
        Mob entity = event.getEntity();
        if (EntityBlockingEventHandler.shouldBlockEntity((Entity)entity, pos = new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ()))) {
            event.setResult(Event.Result.DENY);
            event.setSpawnCancelled(true);
            event.setCanceled(true);
            if (log) {
                Torchmaster.Log.debug("Blocking spawn of {}", (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()));
            }
        } else if (log) {
            Torchmaster.Log.debug("Allowed spawn of {}", (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()));
        }
    }

    public static boolean shouldBlockEntity(Entity entity, BlockPos pos) {
        Level world = entity.m_20193_();
        return world.getCapability(ModCaps.TEB_REGISTRY).map(reg -> reg.shouldBlockEntity(entity, pos)).orElse(false);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onVillageSiegeEvent(VillageSiegeEvent event) {
        if (!((Boolean)TorchmasterConfig.GENERAL.blockVillageSieges.get()).booleanValue()) {
            return;
        }
        boolean log = (Boolean)TorchmasterConfig.GENERAL.logSpawnChecks.get();
        if (log) {
            Torchmaster.Log.debug("VillageSiegeEvent - Pos: {}", (Object)event.getAttemptedSpawnPos());
        }
        if (!((Boolean)TorchmasterConfig.GENERAL.aggressiveSpawnChecks.get()).booleanValue() && event.getResult() == Event.Result.ALLOW) {
            return;
        }
        Vec3 vec = event.getAttemptedSpawnPos();
        BlockPos pos = new BlockPos((int)vec.f_82479_, (int)vec.f_82480_, (int)vec.f_82481_);
        Level level = event.getLevel();
        level.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> {
            if (reg.shouldBlockVillageSiege(pos)) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                if (log) {
                    Torchmaster.Log.debug("Blocking village siege @ {}", (Object)pos);
                }
            } else if (log) {
                Torchmaster.Log.debug("Allowed village siege @ {}", (Object)pos);
            }
        });
    }

    @SubscribeEvent
    public static void onWorldAttachCapabilityEvent(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("torchmaster", "registry"), (ICapabilityProvider)new LightsRegistryCapability());
    }

    @SubscribeEvent
    public static void onGlobalTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            if (Torchmaster.server == null) {
                return;
            }
            for (ServerLevel level : Torchmaster.server.m_129785_()) {
                level.m_46473_().m_6180_("torchmaster_" + level.m_46472_().m_211136_());
                level.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> reg.onGlobalTick((Level)level));
                level.m_46473_().m_7238_();
            }
        }
    }
}

