/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.platform.TagSerializable;
import com.almostreliable.merequester.requester.abstraction.RequestHost;
import com.almostreliable.merequester.requester.status.RequestStatus;
import com.google.common.primitives.Ints;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Requests
implements MEStorage,
GenericInternalInventory,
InternalInventory,
TagSerializable<CompoundTag> {
    @Nullable
    private final RequestHost host;
    private final Request[] requests;
    private final int size;

    public Requests(@Nullable RequestHost host) {
        this.host = host;
        this.size = Platform.getRequestLimit();
        this.requests = new Request[this.size];
        for (int i = 0; i < this.requests.length; ++i) {
            this.requests[i] = new Request(i);
        }
    }

    public Requests() {
        this(null);
    }

    public Request get(int index) {
        return this.requests[index];
    }

    public int size() {
        return this.size;
    }

    @Nullable
    public GenericStack getStack(int index) {
        return this.get(index).toGenericStack();
    }

    @Nullable
    public AEKey getKey(int index) {
        return this.get(index).getKey();
    }

    public long getAmount(int index) {
        return this.get(index).getAmount();
    }

    public long getMaxAmount(AEKey key) {
        return 1L;
    }

    public long getCapacity(AEKeyType keyType) {
        return 1L;
    }

    public boolean canInsert() {
        return true;
    }

    public boolean canExtract() {
        return false;
    }

    public void setStack(int index, @Nullable GenericStack stack) {
        this.get(index).updateKey(stack);
    }

    public boolean isAllowed(AEKey key) {
        return true;
    }

    public long insert(int index, AEKey key, long amount, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            return amount;
        }
        if (this.host == null || this.host.isClientSide()) {
            this.get(index).setClientKey(key, amount);
        } else {
            this.get(index).updateKey(new GenericStack(key, amount));
        }
        return amount;
    }

    public long extract(int index, AEKey key, long amount, Actionable mode) {
        throw new UnsupportedOperationException();
    }

    public void onChange() {
        if (this.host != null) {
            this.host.saveChanges();
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.size(); ++i) {
            tag.m_128365_(String.valueOf(i), (Tag)this.get(i).serialize());
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).deserialize(tag.m_128469_(String.valueOf(i)));
        }
    }

    public int firstAvailableIndex() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getKey(i) != null) continue;
            return i;
        }
        return -1;
    }

    public Component getDescription() {
        if (this.host == null) {
            return Component.m_237119_();
        }
        return this.host.getTerminalName();
    }

    public void beginBatch() {
    }

    public void endBatch() {
    }

    public void endBatchSuppressed() {
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.m_41619_() || this.convertToSuitableStack(stack) != null;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        AEKey aEKey;
        GenericStack genericStack = this.getStack(slot);
        if (genericStack != null && (aEKey = genericStack.what()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            return itemKey.toStack();
        }
        return GenericStack.wrapInItemStack((GenericStack)genericStack);
    }

    public void setItemDirect(int slot, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            this.setStack(slot, null);
        } else {
            GenericStack converted = this.convertToSuitableStack(stack);
            if (converted != null) {
                this.setStack(slot, converted);
            }
        }
    }

    @Nullable
    private GenericStack convertToSuitableStack(ItemStack stack) {
        AEItemKey itemKey;
        if (stack.m_41619_()) {
            return null;
        }
        GenericStack unwrappedStack = GenericStack.unwrapItemStack((ItemStack)stack);
        ItemStack returnStack = stack;
        if (unwrappedStack != null) {
            AEKey aEKey = unwrappedStack.what();
            if (aEKey instanceof AEItemKey) {
                itemKey = (AEItemKey)aEKey;
                returnStack = itemKey.toStack(Math.max(1, Ints.saturatedCast((long)unwrappedStack.amount())));
            } else {
                return unwrappedStack;
            }
        }
        return (itemKey = AEItemKey.of((ItemStack)returnStack)) != null ? new GenericStack((AEKey)itemKey, (long)returnStack.m_41613_()) : null;
    }

    public final class Request
    implements TagSerializable<CompoundTag> {
        private static final String STATE_ID = "state";
        private static final String KEY_ID = "key";
        private static final String AMOUNT_ID = "amount";
        private static final String BATCH_ID = "batch";
        private static final String STATUS_ID = "status";
        private final int index;
        private boolean state = true;
        @Nullable
        private AEKey key;
        private long amount;
        private long batch = 1L;
        private RequestStatus clientStatus = RequestStatus.IDLE;

        private Request(int index) {
            this.index = index;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_(STATE_ID, this.state);
            if (this.key != null) {
                tag.m_128365_(KEY_ID, (Tag)this.key.toTagGeneric());
            }
            tag.m_128356_(AMOUNT_ID, this.amount);
            tag.m_128356_(BATCH_ID, this.batch);
            tag.m_128405_(STATUS_ID, this.clientStatus.ordinal());
            return tag;
        }

        @Override
        public void deserialize(CompoundTag tag) {
            this.state = tag.m_128471_(STATE_ID);
            this.key = tag.m_128441_(KEY_ID) ? AEKey.fromTagGeneric((CompoundTag)tag.m_128469_(KEY_ID)) : null;
            this.amount = tag.m_128454_(AMOUNT_ID);
            this.batch = tag.m_128454_(BATCH_ID);
            this.clientStatus = RequestStatus.values()[tag.m_128451_(STATUS_ID)];
        }

        public void updateState(boolean state) {
            if (this.state != state) {
                this.state = state;
                if (Requests.this.host != null) {
                    Requests.this.host.saveChanges();
                }
            }
        }

        public void updateAmount(long amount) {
            if (this.key == null || amount <= 0L) {
                this.resetSlot();
                return;
            }
            if (this.amount != amount) {
                this.amount = amount;
                if (Requests.this.host != null) {
                    Requests.this.host.saveChanges();
                }
            }
        }

        public void updateBatch(long batch) {
            long oldBatch = this.batch;
            this.batch = (long)Mth.m_14036_((float)batch, (float)1.0f, (float)batch);
            if (oldBatch != this.batch && Requests.this.host != null) {
                Requests.this.host.saveChanges();
            }
        }

        public String toString() {
            return Utils.f("Request[state={}, key={}, amount={}, batch={}, client_status={}]", new Object[]{this.state, this.key == null ? "none" : this.key.getDisplayName(), this.amount, this.batch, this.clientStatus});
        }

        public boolean isDifferent(Request clientRequest) {
            return this.state != clientRequest.state || !Objects.equals(this.key, clientRequest.key) || this.amount != clientRequest.amount || this.batch != clientRequest.batch || this.clientStatus != clientRequest.clientStatus;
        }

        @Nullable
        private GenericStack toGenericStack() {
            if (this.key == null) {
                return null;
            }
            return new GenericStack(this.key, this.amount);
        }

        private void updateKey(@Nullable GenericStack stack) {
            if (stack == null) {
                if (this.key != null) {
                    this.resetSlot();
                }
                return;
            }
            if (this.key != null && this.key.matches(stack)) {
                if (this.amount != stack.amount()) {
                    this.updateAmount(stack.amount());
                }
                return;
            }
            this.key = stack.what();
            this.amount = stack.amount();
            this.batch = stack.what().getAmountPerUnit();
            this.keyChanged();
        }

        private void setClientKey(AEKey key, long amount) {
            this.key = key;
            this.amount = amount;
        }

        private void keyChanged() {
            if (Requests.this.host != null) {
                Requests.this.host.requestChanged(this.index);
            }
        }

        private void resetSlot() {
            if (this.key == null && this.amount == 0L) {
                return;
            }
            this.key = null;
            this.amount = 0L;
            this.batch = 1L;
            this.keyChanged();
        }

        public int getIndex() {
            return this.index;
        }

        public boolean getState() {
            return this.state;
        }

        @Nullable
        public AEKey getKey() {
            return this.key;
        }

        public long getAmount() {
            return this.amount;
        }

        public long getBatch() {
            return this.batch;
        }

        @OnlyIn(value=Dist.CLIENT)
        public RequestHost getRequesterReference() {
            assert (Requests.this.host != null);
            return Requests.this.host;
        }

        public RequestStatus getClientStatus() {
            return this.clientStatus;
        }

        void setClientStatus(RequestStatus clientStatus) {
            this.clientStatus = clientStatus;
        }

        public boolean isRequesting() {
            return this.state && this.key != null;
        }
    }
}

