/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile.multiblock;

import com.jerry.mekanism_extras.common.content.matrix.ExtraMatrixMultiblockData;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import java.util.Collections;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.ProxiedEnergyContainerHolder;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.multiblock.IMultiblockEjector;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.CableUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityReinforcedInductionPort
extends TileEntityReinforcedInductionCasing
implements IMultiblockEjector {
    private Set<Direction> outputDirections = Collections.emptySet();

    public TileEntityReinforcedInductionPort(BlockPos pos, BlockState state) {
        super((IBlockProvider)ExtraBlock.REINFORCED_INDUCTION_PORT, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return ProxiedEnergyContainerHolder.create(side -> !this.getActive(), side -> this.getActive(), side -> ((ExtraMatrixMultiblockData)this.getMultiblock()).getEnergyContainers((Direction)side));
    }

    protected boolean onUpdateServer(ExtraMatrixMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        if (multiblock.isFormed() && this.getActive()) {
            CableUtils.emit(this.outputDirections, (IEnergyContainer)multiblock.getEnergyContainer(), (BlockEntity)this);
        }
        return needsPacket;
    }

    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.ENERGY) {
            return false;
        }
        return super.persists(type);
    }

    public void setEjectSides(Set<Direction> sides) {
        this.outputDirections = sides;
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.m_5661_((Component)MekanismLang.INDUCTION_PORT_MODE.translateColored(EnumColor.GRAY, new Object[]{BooleanStateDisplay.InputOutput.of((boolean)oldMode, (boolean)true)}), true);
        }
        return InteractionResult.SUCCESS;
    }

    public int getRedstoneLevel() {
        return ((ExtraMatrixMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    @ComputerMethod(methodDescription="true -> output, false -> input.")
    boolean getMode() {
        return this.getActive();
    }

    @ComputerMethod(methodDescription="true -> output, false -> input")
    void setMode(boolean output) {
        this.setActive(output);
    }
}

