/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.resource.ore;

import com.jerry.mekanism_extras.common.resource.ExtraResource;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mekanism.common.resource.IResource;
import mekanism.common.resource.ore.BaseOreConfig;
import mekanism.common.resource.ore.OreAnchor;
import mekanism.common.world.height.HeightShape;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum ExtraOreType implements StringRepresentable
{
    NAQUADAH((IResource)ExtraResource.NAQUADAH, new BaseOreConfig("small", 6, 0.0f, 4, HeightShape.TRAPEZOID, OreAnchor.absolute((int)-63), OreAnchor.absolute((int)-60))),
    END_NAQUADAH((IResource)ExtraResource.END_NAQUADAH, new BaseOreConfig("middle", 8, 0.0f, 4, HeightShape.TRAPEZOID, OreAnchor.absolute((int)15), OreAnchor.absolute((int)25)));

    public static Codec<ExtraOreType> CODEC;
    private final List<BaseOreConfig> baseConfigs;
    private final IResource resource;
    private final int minExp;
    private final int maxExp;

    private ExtraOreType(IResource resource, BaseOreConfig ... configs) {
        this(resource, 0, configs);
    }

    private ExtraOreType(IResource resource, int exp, BaseOreConfig ... configs) {
        this(resource, exp, exp, configs);
    }

    private ExtraOreType(IResource resource, int minExp, int maxExp, BaseOreConfig ... configs) {
        this.resource = resource;
        this.minExp = minExp;
        this.maxExp = maxExp;
        this.baseConfigs = List.of(configs);
    }

    public IResource getResource() {
        return this.resource;
    }

    public List<BaseOreConfig> getBaseConfigs() {
        return this.baseConfigs;
    }

    public int getMinExp() {
        return this.minExp;
    }

    public int getMaxExp() {
        return this.maxExp;
    }

    public static ExtraOreType get(IResource resource) {
        for (ExtraOreType ore : ExtraOreType.values()) {
            if (resource != ore.resource) continue;
            return ore;
        }
        return null;
    }

    @NotNull
    public String m_7912_() {
        return this.resource.getRegistrySuffix();
    }

    static {
        CODEC = StringRepresentable.m_216439_(ExtraOreType::values);
    }

    public record OreVeinType(ExtraOreType type, int index) {
        public static final Codec<OreVeinType> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CODEC.fieldOf("type").forGetter(config -> config.type), (App)Codec.INT.fieldOf("index").forGetter(config -> config.index)).apply((Applicative)builder, OreVeinType::new));

        public OreVeinType {
            if (index < 0 || index >= type.getBaseConfigs().size()) {
                throw new IndexOutOfBoundsException("Vein Type index out of range: " + index);
            }
        }

        public String name() {
            return "ore_" + this.type.getResource().getRegistrySuffix() + "_" + this.type.getBaseConfigs().get(this.index).name();
        }
    }
}

