/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.network.to_server;

import com.jerry.mekanism_extras.common.registry.ExtraContainerTypes;
import com.jerry.mekanism_extras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import java.util.function.BiFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class ExtraPacketGuiButtonPress
implements IMekanismPacket {
    private final Type type = Type.TILE;
    private ClickedTileButton tileButton;
    private int extra;
    private BlockPos tilePosition;

    public ExtraPacketGuiButtonPress(ClickedTileButton buttonClicked, BlockEntity tile) {
        this(buttonClicked, tile.m_58899_());
    }

    public ExtraPacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public ExtraPacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        MenuProvider provider;
        TileEntityMekanism tile;
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        if (this.type == Type.TILE && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.m_9236_(), (BlockPos)this.tilePosition)) != null && (provider = this.tileButton.getProvider(tile, this.extra)) != null) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buf -> {
                buf.m_130064_(this.tilePosition);
                buf.m_130130_(this.extra);
            });
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
        if (this.type == Type.TILE) {
            buffer.m_130068_((Enum)this.tileButton);
            buffer.m_130064_(this.tilePosition);
            buffer.m_130130_(this.extra);
        }
    }

    public static ExtraPacketGuiButtonPress decode(FriendlyByteBuf buffer) {
        switch ((Type)buffer.m_130066_(Type.class)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TILE: 
        }
        return new ExtraPacketGuiButtonPress((ClickedTileButton)buffer.m_130066_(ClickedTileButton.class), buffer.m_130135_(), buffer.m_130242_());
    }

    public static enum ClickedTileButton {
        BACK_BUTTON((tile, extra) -> {
            AttributeGui attributeGui = (AttributeGui)Attribute.get((Block)tile.getBlockType(), AttributeGui.class);
            if (attributeGui != null) {
                return attributeGui.getProvider(tile);
            }
            return null;
        }),
        TAB_MAIN((tile, extra) -> {
            if (tile instanceof TileEntityReinforcedInductionCasing) {
                return ExtraContainerTypes.REINFORCED_INDUCTION_MATRIX.getProvider((ILangEntry)MekanismLang.MATRIX, tile);
            }
            return null;
        }),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityReinforcedInductionCasing) {
                return ExtraContainerTypes.MATRIX_STATS.getProvider((ILangEntry)MekanismLang.MATRIX_STATS, tile);
            }
            return null;
        });

        private final BiFunction<TileEntityMekanism, Integer, MenuProvider> providerFromTile;

        private ClickedTileButton(BiFunction<TileEntityMekanism, Integer, MenuProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public MenuProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }

    public static enum Type {
        TILE;

    }
}

