/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.client.render.tileentity;

import com.jerry.mekanism_extras.common.tile.ExtraTileEntityFluidTank;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ExtraRenderFluidTank
extends MekanismTileEntityRenderer<ExtraTileEntityFluidTank> {
    private static final Map<FluidStack, Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterFluids = new HashMap<FluidStack, Int2ObjectMap<MekanismRenderer.Model3D>>();
    private static final Map<FluidStack, Int2ObjectMap<MekanismRenderer.Model3D>> cachedValveFluids = new HashMap<FluidStack, Int2ObjectMap<MekanismRenderer.Model3D>>();
    private static final int stages = 1400;

    public ExtraRenderFluidTank(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public static void resetCachedModels() {
        cachedCenterFluids.clear();
        cachedValveFluids.clear();
    }

    protected void render(ExtraTileEntityFluidTank tile, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, @NotNull ProfilerFiller profiler) {
        FluidStack fluid = tile.fluidTank.getFluid();
        float fluidScale = tile.prevScale;
        Lazy buffer = Lazy.of(() -> renderer.m_6299_(Sheets.m_110792_()));
        if (!fluid.isEmpty() && fluidScale > 0.0f) {
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)ExtraRenderFluidTank.getFluidModel(fluid, fluidScale), (PoseStack)matrix, (VertexConsumer)((VertexConsumer)buffer.get()), (int)MekanismRenderer.getColorARGB((FluidStack)fluid, (float)fluidScale), (int)MekanismRenderer.calculateGlowLight((int)light, (FluidStack)fluid), (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT, (Camera)this.getCamera(), (BlockPos)tile.m_58899_());
        }
        if (!tile.valveFluid.isEmpty() && !MekanismUtils.lighterThanAirGas((FluidStack)tile.valveFluid)) {
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)this.getValveModel(tile.valveFluid, fluidScale), (PoseStack)matrix, (VertexConsumer)((VertexConsumer)buffer.get()), (int)MekanismRenderer.getColorARGB((FluidStack)tile.valveFluid), (int)MekanismRenderer.calculateGlowLight((int)light, (FluidStack)tile.valveFluid), (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT, (Camera)this.getCamera(), (BlockPos)tile.m_58899_());
        }
    }

    @NotNull
    protected String getProfilerSection() {
        return "fluidTank";
    }

    private MekanismRenderer.Model3D getValveModel(@NotNull FluidStack fluid, float fluidScale) {
        return (MekanismRenderer.Model3D)cachedValveFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap()).computeIfAbsent(Math.min(1399, (int)(fluidScale * 1399.0f)), stage -> new MekanismRenderer.Model3D().setSideRender(side -> side.m_122434_().m_122479_()).prepFlowing(fluid).xBounds(0.3225f, 0.6775f).yBounds(0.0625f + 0.875f * ((float)stage / 1400.0f), 0.9375f).zBounds(0.3225f, 0.6775f));
    }

    public static MekanismRenderer.Model3D getFluidModel(@NotNull FluidStack fluid, float fluidScale) {
        return (MekanismRenderer.Model3D)cachedCenterFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap()).computeIfAbsent(ModelRenderer.getStage((FluidStack)fluid, (int)1400, (double)fluidScale), stage -> new MekanismRenderer.Model3D().setTexture(MekanismRenderer.getFluidTexture((FluidStack)fluid, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL)).setSideRender(Direction.DOWN, false).setSideRender(Direction.UP, stage < 1400).xBounds(0.135f, 0.865f).yBounds(0.0625f, 0.0625f + 0.875f * ((float)stage / 1400.0f)).zBounds(0.135f, 0.865f));
    }
}

