/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public abstract class MovingStorageOpenersCounter {
    private static final int CHECK_TICK_DELAY = 5;
    private int openCount = 0;
    private double maxInteractionRange = 0.0;
    private long nextOpenRecheck;

    protected abstract void onOpen();

    protected abstract void onClose();

    protected abstract boolean isOwnContainer(Player var1);

    public void incrementOpeners(Player player, Entity entity) {
        int i;
        if ((i = this.openCount++) == 0) {
            this.onOpen();
            player.m_9236_().m_142346_((Entity)player, GameEvent.f_157803_, entity.m_20183_());
            this.nextOpenRecheck = player.m_9236_().m_46467_() + 5L;
        }
        this.maxInteractionRange = Math.max(5.0, this.maxInteractionRange);
    }

    public void decrementOpeners(Player player, Entity entity) {
        --this.openCount;
        if (this.openCount == 0) {
            this.onClose();
            player.m_9236_().m_142346_((Entity)player, GameEvent.f_157802_, entity.m_20183_());
            this.maxInteractionRange = 0.0;
        }
    }

    private List<Player> getPlayersWithContainerOpen(Level level, BlockPos pos) {
        double maxDistance = this.maxInteractionRange + 4.0;
        AABB aabb = new AABB(pos).m_82400_(maxDistance);
        return level.m_142425_(EntityTypeTest.m_156916_(Player.class), aabb, this::isOwnContainer);
    }

    public void tick(Level level, Entity entity) {
        if (level.m_46467_() > this.nextOpenRecheck && (level.m_46467_() - this.nextOpenRecheck < 15L || this.openCount > 0)) {
            this.recheckOpeners(entity);
        }
    }

    public void recheckOpeners(Entity entity) {
        Level level = entity.m_9236_();
        List<Player> playersWithStorageOpen = this.getPlayersWithContainerOpen(level, entity.m_20183_());
        this.maxInteractionRange = 5.0;
        int numberOfPlayers = playersWithStorageOpen.size();
        if (this.openCount != numberOfPlayers) {
            if (numberOfPlayers != 0 && this.openCount == 0) {
                this.onOpen();
                level.m_142346_(null, GameEvent.f_157803_, entity.m_20183_());
            } else if (numberOfPlayers == 0) {
                this.onClose();
                level.m_142346_(null, GameEvent.f_157802_, entity.m_20183_());
            }
            this.openCount = numberOfPlayers;
        }
        if (numberOfPlayers > 0) {
            this.nextOpenRecheck = level.m_46467_() + 5L;
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }
}

