/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common;

import com.google.common.collect.Queues;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsMessage;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.upgrades.infinity.InfinityUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ISneakItemInteractionBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

public class CommonEventHandler {
    private static final int AVERAGE_MAX_ITEM_ENTITY_DROP_COUNT = 20;
    private final Queue<TickTask> pendingTickTasks = Queues.newConcurrentLinkedQueue();

    public void registerHandlers() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::onPlayerLoggedIn);
        eventBus.addListener(this::onPlayerChangedDimension);
        eventBus.addListener(this::onPlayerRespawn);
        eventBus.addListener(this::handleTooManyDropsBreak);
        eventBus.addListener(this::handleBreakStorageWithInfinityUpgrade);
        eventBus.addListener(this::onLimitedBarrelLeftClicked);
        eventBus.addListener(this::onSneakItemBlockInteraction);
        eventBus.addListener(this::onLevelTick);
    }

    private void onLimitedBarrelLeftClicked(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.m_7500_()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof LimitedBarrelBlock)) {
            return;
        }
        LimitedBarrelBlock limitedBarrel = (LimitedBarrelBlock)block;
        if (limitedBarrel.tryToTakeItem(state, level, pos, player)) {
            event.setCanceled(true);
        }
    }

    private void onSneakItemBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntity().m_6144_()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof ISneakItemInteractionBlock)) {
            return;
        }
        ISneakItemInteractionBlock sneakItemInteractionBlock = (ISneakItemInteractionBlock)block;
        if (sneakItemInteractionBlock.trySneakItemInteraction(event.getEntity(), event.getHand(), state, level, pos, event.getHitVec(), event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void sendPlayerSettingsToClient(Player player) {
        String playerTagName = "sophisticatedStorageSettings";
        PacketHandler.INSTANCE.sendToClient((ServerPlayer)player, (Object)new SyncPlayerSettingsMessage(playerTagName, SettingsManager.getPlayerSettingsTag((Player)player, (String)playerTagName)));
    }

    private void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void onLevelTick(TickEvent.LevelTickEvent event) {
        ServerLevel serverLevel;
        block4: {
            block3: {
                Level level;
                if (event.side != LogicalSide.SERVER || !((level = event.level) instanceof ServerLevel)) break block3;
                serverLevel = (ServerLevel)level;
                if (!this.pendingTickTasks.isEmpty()) break block4;
            }
            return;
        }
        Iterator it = this.pendingTickTasks.iterator();
        while (it.hasNext()) {
            TickTask tickTask = (TickTask)it.next();
            if (tickTask.m_136254_() > serverLevel.m_7654_().m_129921_()) continue;
            tickTask.run();
            it.remove();
        }
    }

    private void handleBreakStorageWithInfinityUpgrade(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(event.getState().m_60734_() instanceof StorageBlockBase)) {
            return;
        }
        if (WorldHelper.getBlockEntity((BlockGetter)event.getLevel(), (BlockPos)event.getPos(), StorageBlockEntity.class).map(storageBlockEntity -> storageBlockEntity.getStorageWrapper().getUpgradeHandler().getTypeWrappers(InfinityUpgradeItem.TYPE).stream().anyMatch(w -> !player.m_20310_(w.getPermissionLevel()))).orElse(false).booleanValue()) {
            event.setCanceled(true);
            player.m_5661_((Component)StorageTranslationHelper.INSTANCE.translStatusMessage("infinity_upgrade_only_admin_break", new Object[0]).m_130940_(ChatFormatting.RED), true);
        }
    }

    private void handleTooManyDropsBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(event.getState().m_60734_() instanceof WoodStorageBlockBase) || player.m_6144_()) {
            return;
        }
        Level level = player.m_9236_();
        BlockPos pos = event.getPos();
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(wbe -> {
            InventoryHandler inventoryHandler;
            int startCountingFromSlot;
            Block patt6270$temp;
            ChestBlockEntity cbe;
            if (wbe.isPacked() || Boolean.TRUE.equals(Config.COMMON.dropPacked.get())) {
                return;
            }
            AtomicInteger droppedItemEntityCount = new AtomicInteger(0);
            if (wbe instanceof ChestBlockEntity && !(cbe = (ChestBlockEntity)wbe).isMainChest() && (patt6270$temp = level.m_8055_(pos).m_60734_()) instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)patt6270$temp;
                startCountingFromSlot = chestBlock.getNumberOfInventorySlots();
                inventoryHandler = cbe.getMainStorageWrapper().getInventoryHandler();
            } else {
                startCountingFromSlot = 0;
                inventoryHandler = wbe.getStorageWrapper().getInventoryHandler();
            }
            InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
                if (stack.m_41619_() || slot < startCountingFromSlot) {
                    return;
                }
                droppedItemEntityCount.addAndGet((int)Math.ceil((double)stack.m_41613_() / (double)Math.min(stack.m_41741_(), 20)));
            }, () -> false, (boolean)false);
            if (droppedItemEntityCount.get() > (Integer)Config.SERVER.tooManyItemEntityDrops.get()) {
                event.setCanceled(true);
                ItemBase packingTapeItem = (ItemBase)ModItems.PACKING_TAPE.get();
                MutableComponent packingTapeItemName = packingTapeItem.m_7626_(new ItemStack((ItemLike)packingTapeItem)).m_6881_().m_130940_(ChatFormatting.GREEN);
                BlockState state = event.getState();
                player.m_213846_((Component)StorageTranslationHelper.INSTANCE.translStatusMessage("too_many_item_entity_drops", new Object[]{state.m_60734_().getCloneItemStack(state, (HitResult)new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), Direction.DOWN, pos, true), (BlockGetter)level, pos, player).m_41786_().m_6881_().m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)String.valueOf(droppedItemEntityCount.get())).m_130940_(ChatFormatting.RED), packingTapeItemName}));
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    level.m_186460_(pos, state.m_60734_(), 2);
                    this.pendingTickTasks.add(new TickTask(serverLevel.m_7654_().m_129921_() + 2, () -> {
                        wbe.setUpdateBlockRender();
                        WorldHelper.notifyBlockUpdate((BlockEntity)wbe);
                    }));
                }
            }
        });
    }
}

