/*
 * Decompiled with CFR 0.152.
 */
package com.reyzerbit.biggerreactorscompat.thermal.fluidtypes;

import cofh.lib.common.fluid.FluidCoFH;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.reyzerbit.biggerreactorscompat.thermal.fluids.EnderGas;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class EnderGasType
extends FluidType {
    public EnderGasType(FluidType.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL = new ResourceLocation("biggerreactorscompat:block/fluids/ender_gas_still");
            private static final ResourceLocation FLOW = new ResourceLocation("biggerreactorscompat:block/fluids/ender_gas_flow");

            public ResourceLocation getStillTexture() {
                return STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOW;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return FluidCoFH.WATER_OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return FluidCoFH.UNDERWATER_LOCATION;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return EnderGas.gasParticleColor;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                nearDistance = -8.0f;
                farDistance = 4.0f;
                if (farDistance > renderDistance) {
                    farDistance = renderDistance;
                    shape = FogShape.CYLINDER;
                }
                RenderSystem.setShaderFogStart((float)nearDistance);
                RenderSystem.setShaderFogEnd((float)farDistance);
                RenderSystem.setShaderFogShape((FogShape)shape);
            }
        });
    }
}

