/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.ae2insertexportcard.screen;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.upgrades.Upgrades;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.UpgradesPanel;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.slot.FakeSlot;
import com.ultramega.ae2insertexportcard.AE2InsertExportCard;
import com.ultramega.ae2insertexportcard.container.CardPlayerSlot;
import com.ultramega.ae2insertexportcard.container.UpgradeContainerMenu;
import com.ultramega.ae2insertexportcard.network.LockSlotUpdateMessage;
import com.ultramega.ae2insertexportcard.network.UpgradeUpdateMessage;
import com.ultramega.ae2insertexportcard.util.UpgradeType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UpgradeScreen
extends AEBaseScreen<UpgradeContainerMenu> {
    private static final ResourceLocation CHECKMARK = new ResourceLocation("ae2insertexportcard", "textures/gui/checkmark.png");
    private static final ResourceLocation XMARK = new ResourceLocation("ae2insertexportcard", "textures/gui/xmark.png");
    private static final ResourceLocation MASS_SELECT = new ResourceLocation("ae2insertexportcard", "textures/gui/mass_select.png");
    private final UpgradeType type;
    private final SettingToggleButton<FuzzyMode> fuzzyMode;
    private final int[] selectedInventorySlots;
    private boolean cancel = false;
    private boolean dragging = false;
    private int clickedSlotId = -1;

    public UpgradeScreen(UpgradeType type, UpgradeContainerMenu containerMenu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)containerMenu, playerInventory, title, style);
        this.type = type;
        this.selectedInventorySlots = containerMenu.getUpgradeHost().getSelectedInventorySlots();
        this.widgets.add("upgrades", (ICompositeWidget)new UpgradesPanel(((UpgradeContainerMenu)this.f_97732_).getSlots(SlotSemantics.UPGRADE), this::getCompatibleUpgrades));
        AESubScreen.addBackButton((ISubMenu)((ISubMenu)this.f_97732_), (String)"back", (WidgetContainer)this.widgets);
        this.fuzzyMode = new ServerSettingToggleButton(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.addToLeftToolbar((Button)this.fuzzyMode);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.fuzzyMode.set((Enum)((UpgradeContainerMenu)this.f_97732_).getFuzzyMode());
        this.fuzzyMode.setVisibility(((UpgradeContainerMenu)this.f_97732_).hasUpgrade((ItemLike)AEItems.FUZZY_CARD));
    }

    public void drawBG(GuiGraphics graphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(graphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        for (int i = 0; i < ((UpgradeContainerMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((UpgradeContainerMenu)this.f_97732_).f_38839_.get(i);
            int index = i - 18 - (this.type == UpgradeType.EXPORT ? 3 : 2);
            if (slot instanceof FakeSlot) {
                if (this.type == UpgradeType.INSERT) continue;
                UpgradeScreen.renderSlotHighlight(graphics, this.type, this.f_96547_, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, true, i - 3 + 1);
                continue;
            }
            if (i < 18 || this.selectedInventorySlots.length <= index) continue;
            if (this.selectedInventorySlots[index] >= 1) {
                UpgradeScreen.renderSlotHighlight(graphics, this.type, this.f_96547_, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, true, this.selectedInventorySlots[index]);
                continue;
            }
            if (this.selectedInventorySlots[index] != 0) continue;
            UpgradeScreen.renderSlotHighlight(graphics, this.type, this.f_96547_, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, false, -1);
        }
        UpgradeScreen.renderMassSelect(graphics, this.f_97735_ + 8 + 160, this.f_97736_ + 76);
    }

    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        Slot slot;
        ItemStack itemstack;
        ItemStack itemStack = itemstack = this.f_97711_.m_41619_() ? ((UpgradeContainerMenu)this.f_97732_).m_142621_() : this.f_97711_;
        if (itemstack.m_41619_() && (slot = this.m_97744_(xCoord, yCoord)) instanceof CardPlayerSlot) {
            if (UpgradeScreen.m_96638_() && !slot.m_7993_().m_41619_()) {
                this.cancel = true;
            }
            if (!this.cancel) {
                this.clickedSlotId = slot.f_40219_;
                AE2InsertExportCard.NETWORK_HANDLER.sendToServer(new LockSlotUpdateMessage(this.clickedSlotId, true));
            }
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (!this.cancel && slot instanceof CardPlayerSlot) {
            ItemStack itemstack;
            ItemStack itemStack = itemstack = this.f_97711_.m_41619_() ? ((UpgradeContainerMenu)this.f_97732_).m_142621_() : this.f_97711_;
            if ((!this.dragging || slot.m_7993_().m_41619_() && slot.f_40219_ == this.clickedSlotId) && itemstack.m_41619_()) {
                int slotId = slot.f_40219_ - (18 + (this.type == UpgradeType.EXPORT ? 3 : 2));
                if (button == 0) {
                    this.increaseSelectedInventorySlot(this.type, slotId);
                } else if (button == 1) {
                    this.selectedInventorySlots[slotId] = 0;
                }
                this.sendUpdate();
            }
        }
        this.cancel = false;
        this.dragging = false;
        this.clickedSlotId = -1;
        boolean clickedStorage = this.m_6774_(169, 77, 4, 5, mouseX, mouseY);
        boolean clickedHotbar = this.m_6774_(169, 135, 4, 5, mouseX, mouseY);
        if (clickedStorage || clickedHotbar) {
            int start = clickedHotbar ? 0 : 9;
            int end = clickedHotbar ? 9 : 36;
            for (int i = start; i < end; ++i) {
                if (button == 0) {
                    this.increaseSelectedInventorySlot(this.type, i);
                    continue;
                }
                if (button != 1) continue;
                this.selectedInventorySlots[i] = 0;
            }
            this.sendUpdate();
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void increaseSelectedInventorySlot(UpgradeType type, int index) {
        if (type == UpgradeType.EXPORT) {
            if (this.selectedInventorySlots[index] >= 18) {
                this.selectedInventorySlots[index] = 0;
            } else {
                int n = index;
                this.selectedInventorySlots[n] = this.selectedInventorySlots[n] + 1;
            }
        } else {
            this.selectedInventorySlots[index] = this.selectedInventorySlots[index] == 0 ? 1 : 0;
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        ItemStack itemstack;
        this.dragging = true;
        ItemStack itemStack = itemstack = this.f_97711_.m_41619_() ? ((UpgradeContainerMenu)this.f_97732_).m_142621_() : this.f_97711_;
        if (this.clickedSlotId != -1 && itemstack.m_41619_()) {
            this.m_6597_((Slot)((UpgradeContainerMenu)this.f_97732_).f_38839_.get(this.clickedSlotId), this.clickedSlotId, button, ClickType.PICKUP);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public static void renderSlotHighlight(GuiGraphics graphics, UpgradeType type, Font font, int x, int y, boolean checked, int filterIndex) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        if (checked) {
            if (type == UpgradeType.INSERT) {
                graphics.m_280163_(CHECKMARK, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            } else {
                graphics.m_280488_(font, String.valueOf(filterIndex), x + 16 - font.m_92895_(String.valueOf(filterIndex)), y, Color.GREEN.hashCode());
            }
        } else {
            graphics.m_280163_(XMARK, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        graphics.m_280168_().m_85849_();
    }

    public static void renderMassSelect(GuiGraphics graphics, int x, int y) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        graphics.m_280163_(MASS_SELECT, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.m_280163_(MASS_SELECT, x, y + 48 + 10, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.m_280168_().m_85849_();
    }

    public void sendUpdate() {
        AE2InsertExportCard.NETWORK_HANDLER.sendToServer(new UpgradeUpdateMessage(this.type.getId(), this.selectedInventorySlots));
    }

    private List<Component> getCompatibleUpgrades() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)GuiText.CompatibleUpgrades.text());
        list.addAll(Upgrades.getTooltipLinesForMachine((ItemLike)((UpgradeContainerMenu)this.f_97732_).getUpgrades().getUpgradableItem()));
        return list;
    }
}

