/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.ae2insertexportcard.container;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.ISubMenuHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.definitions.AEItems;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.FakeSlot;
import appeng.util.ConfigInventory;
import appeng.util.ConfigMenuInventory;
import com.google.common.base.Preconditions;
import com.ultramega.ae2insertexportcard.container.CardPlayerSlot;
import com.ultramega.ae2insertexportcard.item.UpgradeHost;
import com.ultramega.ae2insertexportcard.registry.ModSlotSemantics;
import com.ultramega.ae2insertexportcard.util.UpgradeType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ItemLike;

public class UpgradeContainerMenu
extends AEBaseMenu
implements ISubMenu {
    public static final String INSERT_CARD_ID = "insert_card";
    public static final String EXPORT_CARD_ID = "export_card";
    public static final MenuType<UpgradeContainerMenu> TYPE_INSERT = MenuTypeBuilder.create((id, inventory, host) -> new UpgradeContainerMenu(UpgradeType.INSERT, id, inventory, (WirelessTerminalMenuHost)host, new UpgradeHost(UpgradeType.INSERT, id, inventory, (WirelessTerminalMenuHost)host)), WirelessTerminalMenuHost.class).build("insert_card");
    public static final MenuType<UpgradeContainerMenu> TYPE_EXPORT = MenuTypeBuilder.create((id, inventory, host) -> new UpgradeContainerMenu(UpgradeType.EXPORT, id, inventory, (WirelessTerminalMenuHost)host, new UpgradeHost(UpgradeType.EXPORT, id, inventory, (WirelessTerminalMenuHost)host)), WirelessTerminalMenuHost.class).build("export_card");
    private final UpgradeType type;
    private final WirelessTerminalMenuHost host;
    private final UpgradeHost upgradeHost;
    @GuiSync(value=0)
    public FuzzyMode fzMode = FuzzyMode.IGNORE_ALL;

    public UpgradeContainerMenu(UpgradeType type, int id, Inventory playerInventory, WirelessTerminalMenuHost host, UpgradeHost upgradeHost) {
        super(type == UpgradeType.INSERT ? TYPE_INSERT : TYPE_EXPORT, id, playerInventory, (Object)host);
        this.type = type;
        this.host = host;
        this.upgradeHost = upgradeHost;
        this.setupUpgrades(this.getUpgradeHost().getUpgrades());
        this.addConfigSlots(upgradeHost.filterConfig, type == UpgradeType.INSERT ? ModSlotSemantics.INSERT_CONFIG : ModSlotSemantics.EXPORT_CONFIG);
        this.createCardPlayerInventorySlots(playerInventory);
    }

    private void addConfigSlots(ConfigInventory config, SlotSemantic slotSemantic) {
        ConfigMenuInventory inv = config.createMenuWrapper();
        for (int i = 0; i < 18; ++i) {
            this.addSlot((Slot)new FakeSlot((InternalInventory)inv, i), slotSemantic);
        }
    }

    private void createCardPlayerInventorySlots(Inventory playerInventory) {
        Preconditions.checkState((boolean)this.getSlots(SlotSemantics.PLAYER_INVENTORY).isEmpty(), (Object)"Player inventory was already created");
        for (int i = 0; i < playerInventory.f_35974_.size(); ++i) {
            CardPlayerSlot slot = new CardPlayerSlot((Container)playerInventory, i);
            SlotSemantic s = i < Inventory.m_36059_() ? SlotSemantics.PLAYER_HOTBAR : SlotSemantics.PLAYER_INVENTORY;
            this.addSlot(slot, s);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.isServerSide() && this.getUpgradeHost().getUpgrades().isInstalled((ItemLike)AEItems.FUZZY_CARD)) {
            this.setFuzzyMode((FuzzyMode)this.getUpgradeHost().getConfigManager().getSetting(Settings.FUZZY_MODE));
        }
    }

    public ISubMenuHost getHost() {
        return this.host;
    }

    public UpgradeHost getUpgradeHost() {
        return this.upgradeHost;
    }

    public Object getTarget() {
        return this.upgradeHost;
    }

    public FuzzyMode getFuzzyMode() {
        return this.fzMode;
    }

    public void setFuzzyMode(FuzzyMode fzMode) {
        this.fzMode = fzMode;
    }

    public final IUpgradeInventory getUpgrades() {
        return this.getUpgradeHost().getUpgrades();
    }

    public final boolean hasUpgrade(ItemLike upgradeCard) {
        return this.getUpgrades().isInstalled(upgradeCard);
    }
}

