/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.Tools;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class ItemStackTools {
    private static Set<TagKey<Item>> commonTags = null;

    @Nonnull
    public static ItemStack extractItem(@Nullable BlockEntity tileEntity, int slot, int amount) {
        if (tileEntity == null) {
            return ItemStack.f_41583_;
        }
        return tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> handler.extractItem(slot, amount, false)).orElse(ItemStack.f_41583_);
    }

    @Nonnull
    public static ItemStack getStack(@Nullable BlockEntity tileEntity, int slot) {
        if (tileEntity == null) {
            return ItemStack.f_41583_;
        }
        return tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> handler.getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }

    public static GuiParser.GuiCommand itemStackToGuiCommand(String name, ItemStack item) {
        GuiParser.GuiCommand object = new GuiParser.GuiCommand(name);
        object.parameter(Tools.getId(item).toString());
        object.parameter(item.m_41613_());
        if (item.m_41782_()) {
            String string = item.m_41783_().toString();
            object.command(new GuiParser.GuiCommand("tag").parameter(string));
        }
        return object;
    }

    public static ItemStack guiCommandToItemStack(GuiParser.GuiCommand obj) {
        String itemName = obj.getOptionalPar(0, "minecraft:stick");
        Item item = Tools.getItem(new ResourceLocation(itemName));
        int amount = obj.getOptionalPar(1, 1);
        ItemStack stack = new ItemStack((ItemLike)item, amount);
        obj.findCommand("tag").ifPresent(cmd -> {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)cmd.getOptionalPar(0, ""));
                stack.m_41751_(nbt);
            }
            catch (CommandSyntaxException e) {
                Logging.logError("Error", e);
            }
        });
        return stack;
    }

    public static void addCommonTags(Collection<TagKey<Item>> fromItem, Set<TagKey<Item>> tags) {
        ItemStackTools.findCommonTags();
        for (TagKey<Item> id : fromItem) {
            if (!commonTags.contains(id)) continue;
            tags.add(id);
        }
    }

    public static boolean hasCommonTag(Collection<TagKey<Item>> fromItem) {
        ItemStackTools.findCommonTags();
        for (TagKey<Item> id : fromItem) {
            if (!commonTags.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static void findCommonTags() {
        if (commonTags == null) {
            commonTags = new HashSet<TagKey<Item>>();
            commonTags.add((TagKey<Item>)ItemTags.f_13137_);
            commonTags.add((TagKey<Item>)ItemTags.f_13147_);
            commonTags.add((TagKey<Item>)ItemTags.f_13180_);
            commonTags.add((TagKey<Item>)ItemTags.f_13143_);
            commonTags.add((TagKey<Item>)ItemTags.f_13182_);
            commonTags.add((TagKey<Item>)ItemTags.f_13142_);
            commonTags.add((TagKey<Item>)ItemTags.f_13139_);
            commonTags.add((TagKey<Item>)ItemTags.f_13167_);
            commonTags.add((TagKey<Item>)ItemTags.f_215867_);
            commonTags.add((TagKey<Item>)ItemTags.f_13168_);
            commonTags.add((TagKey<Item>)ItemTags.f_13138_);
            commonTags.add((TagKey<Item>)ItemTags.f_198160_);
            commonTags.add((TagKey<Item>)Tags.Items.CROPS);
            commonTags.add((TagKey<Item>)Tags.Items.GLASS);
            commonTags.add((TagKey<Item>)Tags.Items.GLASS_PANES);
            commonTags.add((TagKey<Item>)Tags.Items.CHESTS);
            commonTags.add((TagKey<Item>)Tags.Items.COBBLESTONE);
            commonTags.add((TagKey<Item>)Tags.Items.NETHERRACK);
            commonTags.add((TagKey<Item>)Tags.Items.OBSIDIAN);
            commonTags.add((TagKey<Item>)Tags.Items.GRAVEL);
            commonTags.add((TagKey<Item>)Tags.Items.SANDSTONE);
            commonTags.add((TagKey<Item>)Tags.Items.END_STONES);
            commonTags.add((TagKey<Item>)Tags.Items.STONE);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_COAL);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_DIAMOND);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_EMERALD);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_GOLD);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_REDSTONE);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_QUARTZ);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_IRON);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_LAPIS);
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "ores/copper")));
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "ores/tin")));
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "ores/silver")));
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "ores/manganese")));
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "ores/platinum")));
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS);
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "storage_blocks/copper")));
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "storage_blocks/tin")));
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "storage_blocks/silver")));
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "storage_blocks/manganese")));
            commonTags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "storage_blocks/platinum")));
        }
    }
}

