/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.spells.nature;

import com.gametechbc.iasspellbooks.api.spells.AbstractUniqueSpell;
import com.yellowbrossproductions.illageandspillage.entities.projectile.PumpkinBombEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class PumpkinSpiceSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("ias_spellbooks", "pumpkin_spice");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(3).setCooldownSeconds(15.0).build();

    public PumpkinSpiceSpell() {
        this.manaCostPerLevel = 25;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 10;
        this.baseManaCost = 30;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_COUGH.get());
    }

    public void onCast(Level world, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        int numberOfEntities = (int)this.getPumpkinCount(spellLevel, caster);
        double radius = 2.5;
        double throwForce = 1.5;
        for (int i = 0; i < numberOfEntities; ++i) {
            double angle = Math.PI * 2 / (double)numberOfEntities * (double)i;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            PumpkinBombEntity pumpkinBomb = new PumpkinBombEntity((EntityType)ModEntityTypes.PumpkinBomb.get(), world);
            pumpkinBomb.setOwner(caster);
            pumpkinBomb.m_6034_(caster.m_20185_() + offsetX, caster.m_20186_() + 1.0, caster.m_20189_() + offsetZ);
            Vec3 throwDirection = new Vec3(offsetX, 0.0, offsetZ).m_82541_().m_82490_(throwForce);
            pumpkinBomb.m_20256_(throwDirection);
            pumpkinBomb.m_6710_(world.m_45963_(Monster.class, TargetingConditions.f_26872_, caster, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), caster.m_20191_().m_82400_(40.0)));
            if (caster.m_5647_() != null) {
                world.m_6188_().m_6546_(pumpkinBomb.m_20149_(), world.m_6188_().m_83489_(caster.m_5647_().m_5758_()));
            }
            world.m_7967_((Entity)pumpkinBomb);
        }
        super.onCast(world, spellLevel, caster, castSource, playerMagicData);
    }

    public float getPumpkinCount(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 2.2f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.ias_spellbooks.pumpkin_count", (Object[])new Object[]{Utils.stringTruncation((double)this.getPumpkinCount(spellLevel, caster), (int)0)}), Component.m_237113_((String)"\u00a79Illage and Spell-age"));
    }
}

