/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.spells.nature;

import com.gametechbc.iasspellbooks.api.spells.IASSSpellAnimations;
import com.yellowbrossproductions.illageandspillage.entities.projectile.WebNetEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class DraglineSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("ias_spellbooks", "dragline");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(8).setCooldownSeconds(15.0).build();

    public DraglineSpell() {
        this.manaCostPerLevel = 2;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 5;
        this.baseManaCost = 5;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return IASSSpellAnimations.SPECTRAL_BLINK;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public void onCast(Level world, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        double radius = this.getRange(spellLevel, caster);
        int maxTargets = this.getMaxTargets(spellLevel);
        List nearbyEntities = caster.m_9236_().m_6443_(LivingEntity.class, caster.m_20191_().m_82400_(radius), entity -> entity != caster && entity.m_6084_() && !entity.m_5833_());
        nearbyEntities.sort((e1, e2) -> {
            boolean e1Visible = caster.m_142582_((Entity)e1);
            boolean e2Visible = caster.m_142582_((Entity)e2);
            return Boolean.compare(e2Visible, e1Visible);
        });
        for (int i = 0; i < Math.min(maxTargets, nearbyEntities.size()); ++i) {
            LivingEntity targetEntity = (LivingEntity)nearbyEntities.get(i);
            WebNetEntity webNet = new WebNetEntity((EntityType)ModEntityTypes.WebNet.get(), caster.m_9236_());
            webNet.m_6034_(targetEntity.m_20185_(), targetEntity.m_20186_() + 1.2, targetEntity.m_20189_());
            webNet.setShooter(caster);
            webNet.setAttachPoint(caster.m_20185_(), caster.m_20186_() + 1.2, caster.m_20189_());
            caster.m_9236_().m_7967_((Entity)webNet);
            Vec3 pullVector = new Vec3(caster.m_20185_() - targetEntity.m_20185_(), caster.m_20186_() - targetEntity.m_20186_(), caster.m_20189_() - targetEntity.m_20189_()).m_82541_().m_82490_(0.1);
            targetEntity.m_20256_(targetEntity.m_20184_().m_82549_(pullVector));
            targetEntity.f_19864_ = true;
        }
        super.onCast(world, spellLevel, caster, castSource, playerMagicData);
    }

    private int getMaxTargets(int spellLevel) {
        return 2 + spellLevel;
    }

    private float getRange(int spellLevel, LivingEntity caster) {
        return 4.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.ias_spellbooks.max_targets", (Object[])new Object[]{this.getMaxTargets(spellLevel)}), Component.m_237110_((String)"ui.ias_spellbooks.radius", (Object[])new Object[]{Float.valueOf(this.getRange(spellLevel, caster))}), Component.m_237113_((String)"\u00a79Illage and Spell-age"));
    }
}

