/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.CustomSelectionList;
import dev.ftb.mods.ftbfiltersystem.filter.ItemTagFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class ItemTagConfigScreen
extends AbstractFilterConfigScreen<ItemTagFilter> {
    private static String lastSearch;
    private final List<TagKey<Item>> matchingTags = new ArrayList<TagKey<Item>>();
    private EditBox searchField;
    private ItemTagList itemTagList;

    public ItemTagConfigScreen(ItemTagFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 200, 176);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.searchField = this.makeSearchEditBox(this.leftPos + 8, this.topPos + 20, () -> lastSearch, s -> {
            lastSearch = s;
        });
        this.updateSearchEntries();
        this.itemTagList = new ItemTagList(this.f_96541_, this.getListWidth() + 8, this.getListHeight(), this.topPos + 32, this.topPos + 35 + this.getListHeight());
        this.itemTagList.m_93507_(this.leftPos + 8);
        this.itemTagList.m_93488_(false);
        this.itemTagList.m_93496_(false);
        this.m_7787_((GuiEventListener)this.itemTagList);
        this.itemTagList.m_6702_().stream().filter(child -> child.tagKey.equals(((ItemTagFilter)this.filter).getTagKey())).findFirst().ifPresent(entry -> this.itemTagList.selectAndCenter(entry));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.itemTagList.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    @Nullable
    protected ItemTagFilter makeNewFilter() {
        if (this.itemTagList.m_93511_() != null) {
            return new ItemTagFilter(((ItemTagFilter)this.filter).getParent(), ((ItemTagList.ItemTagEntry)this.itemTagList.m_93511_()).tagKey);
        }
        if (this.itemTagList.m_6702_().isEmpty() && ResourceLocation.m_135830_((String)this.searchField.m_94155_())) {
            return new ItemTagFilter(((ItemTagFilter)this.filter).getParent(), (TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(this.searchField.m_94155_())));
        }
        return null;
    }

    @Override
    protected void doScheduledUpdate() {
        this.updateSearchEntries();
        this.itemTagList.addChildren();
    }

    private int getListHeight() {
        return 148;
    }

    private int getListWidth() {
        return 176;
    }

    private void updateSearchEntries() {
        String srch = this.searchField.m_94155_().toLowerCase(Locale.ROOT);
        this.matchingTags.clear();
        this.matchingTags.addAll(BuiltInRegistries.f_257033_.m_203613_().filter(tagKey -> srch.isEmpty() || tagKey.f_203868_().toString().toLowerCase(Locale.ROOT).contains(srch)).sorted(Comparator.comparing(TagKey::f_203868_)).toList());
    }

    private class ItemTagList
    extends CustomSelectionList<ItemTagEntry> {
        private static final int ELEMENT_HEIGHT = 12;

        public ItemTagList(Minecraft minecraft, int width, int height, int top, int bottom) {
            super(minecraft, width, height, top, bottom, 12);
            this.addChildren();
        }

        @Override
        protected List<ItemTagEntry> buildChildrenList() {
            return ItemTagConfigScreen.this.matchingTags.stream().map(x$0 -> new ItemTagEntry((TagKey<Item>)x$0)).toList();
        }

        private class ItemTagEntry
        extends CustomSelectionList.Entry<ItemTagEntry> {
            private final TagKey<Item> tagKey;

            private ItemTagEntry(TagKey<Item> tagKey) {
                this.tagKey = tagKey;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                MutableComponent txt = Component.m_237113_((String)this.tagKey.f_203868_().m_135827_()).m_130948_(Style.f_131099_.m_178520_(0x202060)).m_7220_((Component)Component.m_237113_((String)":")).m_7220_((Component)Component.m_237113_((String)this.tagKey.f_203868_().m_135815_()).m_130948_(Style.f_131099_.m_178520_(8405024)));
                guiGraphics.m_280614_(ItemTagConfigScreen.this.f_96547_, (Component)txt, left + 1, top + 1, 0x404040, false);
            }

            @Override
            protected boolean onMouseClick(double x, double y, int button, boolean isDoubleClick) {
                ItemTagList.this.m_6987_((AbstractSelectionList.Entry)this);
                if (isDoubleClick) {
                    ItemTagConfigScreen.this.applyChanges();
                }
                return true;
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.tagKey.f_203868_().toString()});
            }
        }
    }
}

