/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Blcks;

public class SolidCoolantCategory
implements IRecipeCategory<Recipe> {
    public static final RecipeType<Recipe> TYPE = RecipeType.create((String)"powah", (String)"solid_coolant", Recipe.class);
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    private final IDrawable background;
    private final IDrawable icon;

    public SolidCoolantCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blcks.DRY_ICE.get()));
    }

    public RecipeType<Recipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.powah.jei.category.solid.coolant");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 5).addItemStack(recipe.stack);
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        guiGraphics.m_280056_(minecraft.f_91062_, I18n.m_118938_((String)"info.lollipop.amount", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"info.lollipop.mb", (Object[])new Object[]{recipe.amount}), 30, 3, 0x444444, false);
        guiGraphics.m_280056_(minecraft.f_91062_, I18n.m_118938_((String)"info.lollipop.temperature", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"info.lollipop.temperature.c", (Object[])new Object[]{"" + ChatFormatting.DARK_AQUA + recipe.coldness}), 30, 15, 0x444444, false);
    }

    public static List<Recipe> getRecipes(IIngredientManager ingredientManager) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (ItemStack stack : ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
            Pair<Integer, Integer> coolantInfo = PowahAPI.SOLID_COOLANTS.get(id);
            if (coolantInfo == null) continue;
            recipes.add(new Recipe(stack, (Integer)coolantInfo.getLeft(), (Integer)coolantInfo.getRight()));
        }
        return recipes;
    }

    public record Recipe(ItemStack stack, int amount, int coldness) {
    }
}

