/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.thermo.ThermoTile;
import owmii.powah.client.screen.Textures;
import owmii.powah.inventory.ThermoContainer;
import owmii.powah.lib.client.screen.container.AbstractEnergyScreen;
import owmii.powah.lib.client.util.Draw;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.util.Util;

public class ThermoScreen
extends AbstractEnergyScreen<ThermoTile, ThermoContainer> {
    public ThermoScreen(ThermoContainer container, Inventory inv, Component title) {
        super(container, inv, title, Textures.THERMO);
    }

    @Override
    protected void drawBackground(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        TextureAtlasSprite sprite;
        super.drawBackground(gui, partialTicks, mouseX, mouseY);
        Textures.THERMO_GAUGE.drawScalableH(gui, ((ThermoTile)this.te).getEnergy().subSized(), this.f_97735_ + 5, this.f_97736_ + 5);
        Tank tank = ((ThermoTile)this.te).getTank();
        if (!tank.isEmpty() && (sprite = FluidStackHooks.getStillTexture((FluidStack)(fluidStack = tank.getFluid()))) != null) {
            int color = FluidStackHooks.getColor((FluidStack)fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            this.bindTexture(InventoryMenu.f_39692_);
            Draw.gaugeV(sprite, this.f_97735_ + 157, this.f_97736_ + 5, 14, 65, (int)tank.getCapacity(), (int)tank.getFluidAmount());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        long percent = ((ThermoTile)this.te).getGeneration() > 0L ? 100L * ((ThermoTile)this.te).generating / ((ThermoTile)this.te).getGeneration() : 0L;
        gui.m_280056_(this.f_96547_, percent + "% (" + ((ThermoTile)this.te).generating + " FE/t)", this.f_97735_ + 34, this.f_97736_ + 10, 0x555555, false);
    }

    protected void m_280072_(GuiGraphics gui, int mouseX, int mouseY) {
        super.m_280072_(gui, mouseX, mouseY);
        if (Textures.FURNATOR_GAUGE.isMouseOver(this.f_97735_ + 5, this.f_97736_ + 5, mouseX, mouseY)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            Energy energy = ((ThermoTile)this.te).getEnergy();
            list.add(Component.m_237115_((String)"info.lollipop.stored").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(energy.getStored()), Util.numFormat(energy.getCapacity())}).m_130940_(ChatFormatting.DARK_GRAY)));
            list.add(Component.m_237115_((String)"info.lollipop.generates").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(((ThermoTile)this.te).getGeneration())}).m_130940_(ChatFormatting.DARK_GRAY)));
            list.add(Component.m_237115_((String)"info.lollipop.max.extract").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(energy.getMaxExtract())}).m_130940_(ChatFormatting.DARK_GRAY)));
            gui.m_280666_(this.f_96547_, list, mouseX, mouseY);
        }
        Tank tank = ((ThermoTile)this.te).getTank();
        if (this.isMouseOver(mouseX - 157, mouseY - 5, 14, 65)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            if (!tank.isEmpty()) {
                list.add(Component.m_237115_((String)"info.lollipop.coolant").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)FluidStackHooks.getName((FluidStack)tank.getFluid()).m_6879_().m_130940_(ChatFormatting.AQUA)));
                list.add(Component.m_237115_((String)"info.lollipop.stored").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Util.formatTankContent(tank)));
                list.add(Component.m_237115_((String)"info.lollipop.temperature").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.temperature.c", (Object[])new Object[]{"" + ChatFormatting.AQUA + PowahAPI.getCoolant(tank.getFluid().getFluid())}).m_130940_(ChatFormatting.DARK_GRAY)));
            } else {
                list.add(Component.m_237115_((String)"info.lollipop.fluid").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237113_((String)"---").m_130940_(ChatFormatting.DARK_GRAY)));
            }
            gui.m_280666_(this.f_96547_, list, mouseX, mouseY);
        }
    }
}

