/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import stepsword.mahoutsukai.block.BlockBase;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.worldsave.MahouSavedData;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.InvisibleBarrierBlockTileEntity;

public class TangibleBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    public List<BlockPos> lst = null;

    public TangibleBoundaryMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.tangibleBoundary.get(), p, bs);
    }

    @Override
    public int getManaCost() {
        return MTConfig.TANGIBLE_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.TANGIBLE_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.TANGIBLE_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.TANGIBLE_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        if (this.lst == null) {
            this.lst = TangibleBoundaryMahoujinTileEntity.getBox(this.f_58858_, this.getBarrierRadius()).map(a -> new BlockPos((Vec3i)a)).filter(a -> a.m_123341_() == this.f_58858_.m_123341_() - this.getBarrierRadius() || a.m_123341_() == this.f_58858_.m_123341_() + this.getBarrierRadius() || a.m_123342_() == this.f_58858_.m_123342_() - this.getBarrierRadius() || a.m_123342_() == this.f_58858_.m_123342_() + this.getBarrierRadius() || a.m_123343_() == this.f_58858_.m_123343_() - this.getBarrierRadius() || a.m_123343_() == this.f_58858_.m_123343_() + this.getBarrierRadius()).collect(Collectors.toList());
        }
        this.placeAllBarriers(this.lst);
    }

    public static Stream<BlockPos> getBox(BlockPos pos, int radius) {
        return BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, -radius, -radius), (BlockPos)pos.m_7918_(radius, radius, radius));
    }

    public static void removeAllBarriers(BlockPos pos, int radius, Level world) {
        ChunkPos chunkBottom = new ChunkPos(pos.m_7918_(-radius, -radius, -radius));
        ChunkPos chunkTop = new ChunkPos(pos.m_7918_(radius, radius, radius));
        HashSet<BlockPos> toremove = new HashSet<BlockPos>();
        for (int i = chunkBottom.f_45578_; i <= chunkTop.f_45578_; ++i) {
            for (int j = chunkBottom.f_45579_; j <= chunkTop.f_45579_; ++j) {
                LevelChunk c = world.m_6325_(i, j);
                for (Map.Entry entry : c.m_62954_().entrySet()) {
                    if (!(entry.getValue() instanceof InvisibleBarrierBlockTileEntity)) continue;
                    toremove.add((BlockPos)entry.getKey());
                }
            }
        }
        for (BlockPos p : toremove) {
            world.m_46597_(p, Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public void doNotBarrier() {
        TangibleBoundaryMahoujinTileEntity.removeAllBarriers(this.f_58858_, this.getBarrierRadius(), this.f_58857_);
    }

    public void placeAllBarriers(List<BlockPos> box) {
        HashSet<UUID> wl = this.getWhitelist();
        box.forEach(tmp -> {
            if (tmp.m_123341_() == this.f_58858_.m_123341_() - this.getBarrierRadius() || tmp.m_123341_() == this.f_58858_.m_123341_() + this.getBarrierRadius() || tmp.m_123342_() == this.f_58858_.m_123342_() - this.getBarrierRadius() || tmp.m_123342_() == this.f_58858_.m_123342_() + this.getBarrierRadius() || tmp.m_123343_() == this.f_58858_.m_123343_() - this.getBarrierRadius() || tmp.m_123343_() == this.f_58858_.m_123343_() + this.getBarrierRadius()) {
                Block b = this.f_58857_.m_8055_(tmp).m_60734_();
                BlockEntity te = this.f_58857_.m_7702_(tmp);
                if (b instanceof AirBlock || b instanceof TallGrassBlock || b instanceof FlowerBlock) {
                    this.f_58857_.m_46597_(tmp, ((BlockBase)((Object)((Object)ModBlocks.invisibleBarrierBlock.get()))).m_49966_());
                    te = this.f_58857_.m_7702_(tmp);
                    if (te != null) {
                        ((InvisibleBarrierBlockTileEntity)te).setCasterUUID(this.getCasterUUID());
                        ((InvisibleBarrierBlockTileEntity)te).setBoundaryCircle(this.f_58858_);
                        ((InvisibleBarrierBlockTileEntity)te).whitelist = wl;
                    }
                } else if (te instanceof InvisibleBarrierBlockTileEntity && !wl.equals(((InvisibleBarrierBlockTileEntity)te).whitelist)) {
                    ((InvisibleBarrierBlockTileEntity)te).whitelist = wl;
                    ((InvisibleBarrierBlockTileEntity)te).sendUpdates();
                }
            }
        });
    }

    public HashSet<UUID> getWhitelist() {
        MahouSavedData save = new MahouSavedData(this.f_58857_);
        HashSet<UUID> ret = new HashSet<UUID>();
        if (save != null && save.playerContracts != null && save.playerContracts.containsKey((Object)this.getCasterUUID())) {
            ret = new HashSet(save.playerContracts.get((Object)this.getCasterUUID()));
        }
        return ret;
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((ItemLike)ModItems.boundaryTangibleScroll.get());
    }
}

