/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.livingmahou;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.capability.livingmahou.ILivingMahou;

public class LivingMahouStorage {
    private static String AUTHORITY_HIT = "MAHOUTSUKAI_AUTHORITY_HIT";
    private static String FEAR_PERSON = "MAHOUTSUKAI_FEAR_PERSON";
    private static String WOUNDED_X = "MAHOUTSUKAI_FAMILIAR_WOUNDED_BLOCK_X";
    private static String WOUNDED_Y = "MAHOUTSUKAI_FAMILIAR_WOUNDED_BLOCK_Y";
    private static String WOUNDED_Z = "MAHOUTSUKAI_FAMILIAR_WOUNDED_BLOCK_Z";
    private static String KODOKU = "MAHOUTSUKAI_KODOKU";

    public static Tag writeNBT(ILivingMahou instance) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(KODOKU, instance.getKodoku());
        if (instance.getFearPerson() != null) {
            nbt.m_128362_(FEAR_PERSON, instance.getFearPerson());
        }
        nbt.m_128379_(AUTHORITY_HIT, instance.getAuthorityHit());
        if (instance.getLastWoundedPos() != null) {
            Vec3 wounded = instance.getLastWoundedPos();
            nbt.m_128347_(WOUNDED_X, wounded.f_82479_);
            nbt.m_128347_(WOUNDED_Y, wounded.f_82480_);
            nbt.m_128347_(WOUNDED_Z, wounded.f_82481_);
        }
        return nbt;
    }

    public static void readNBT(ILivingMahou instance, Tag nbtb) {
        CompoundTag nbt = (CompoundTag)nbtb;
        instance.clearBuffs();
        if (nbt.m_128403_(FEAR_PERSON)) {
            instance.setFearPerson(nbt.m_128342_(FEAR_PERSON));
        } else {
            instance.setFearPerson(null);
        }
        instance.setAuthorityHit(nbt.m_128471_(AUTHORITY_HIT));
        if (nbt.m_128441_(WOUNDED_X) && nbt.m_128441_(WOUNDED_Y) && nbt.m_128441_(WOUNDED_Z)) {
            instance.setLastWoundedPos(new Vec3(nbt.m_128459_(WOUNDED_X), nbt.m_128459_(WOUNDED_Y), nbt.m_128459_(WOUNDED_Z)));
        }
        instance.setKodoku(nbt.m_128451_(KODOKU));
    }
}

