/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers.vfx;

import cofh.lib.util.helpers.MathHelper;
import net.minecraft.client.gui.GuiGraphics;

public class Color {
    public static final float INT_TO_FLOAT = 0.003921569f;
    public static final Color WHITE = Color.fromRGBA(-1);
    public final int r;
    public final int g;
    public final int b;
    public final int a;

    protected Color(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public static Color fromRGB(int rgb) {
        return new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, 255);
    }

    public static Color fromRGB(int r, int g, int b) {
        return new Color(r, g, b, 255);
    }

    public static Color fromRGBA(int rgba) {
        return new Color(rgba >> 24 & 0xFF, rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba & 0xFF);
    }

    public static Color fromRGBA(int r, int g, int b, int a) {
        return new Color(r, g, b, a);
    }

    public static Color fromFloat(float r, float g, float b, float a) {
        return new Color((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    protected int scale(int channel, float scale) {
        return MathHelper.clamp((int)((float)channel * scale), 0, 255);
    }

    public void apply(GuiGraphics graphics) {
        graphics.m_280246_((float)this.r * 0.003921569f, (float)this.g * 0.003921569f, (float)this.b * 0.003921569f, (float)this.a * 0.003921569f);
    }

    public Color scaleRGB(float scale) {
        return new Color(this.scale(this.r, scale), this.scale(this.g, scale), this.scale(this.b, scale), this.a);
    }

    public Color scaleRGB(float sr, float sg, float sb) {
        return new Color(this.scale(this.r, sr), this.scale(this.g, sg), this.scale(this.b, sb), this.a);
    }

    public Color scaleAlpha(float scale) {
        return new Color(this.r, this.g, this.b, this.scale(this.a, scale));
    }

    public Color scaleRGBA(float sr, float sg, float sb, float sa) {
        return new Color(this.scale(this.r, sr), this.scale(this.g, sg), this.scale(this.b, sb), this.scale(this.a, sa));
    }

    public int toRGBA() {
        return this.r << 24 | this.g << 16 | this.b << 8 | this.a;
    }

    public int toRGB() {
        return this.r << 16 | this.g << 8 | this.b;
    }

    public boolean equals(Color other) {
        return other.r == this.r && other.g == this.g && other.b == this.b && other.a == this.a;
    }

    public boolean equals(int other) {
        return this.equals(Color.fromRGBA(other));
    }

    public boolean sameRGB(Color other) {
        return other.r == this.r && other.g == this.g && other.b == this.b;
    }

    public boolean sameRGB(int other) {
        return this.sameRGB(Color.fromRGBA(other));
    }

    public Color mix(Color other, float amount) {
        return new Color(MathHelper.interpolate(this.r, other.r, amount), MathHelper.interpolate(this.g, other.g, amount), MathHelper.interpolate(this.b, other.b, amount), MathHelper.interpolate(this.a, other.a, amount));
    }

    public double dist(Color other) {
        return Math.sqrt(this.distSqr(other));
    }

    public double distSqr(Color other) {
        long rMean = this.r + other.r >> 1;
        long r = this.r - other.r;
        long g = this.g - other.g;
        long b = this.b - other.b;
        return ((512L + rMean) * r * r >> 8) + 4L * g * g + ((767L - rMean) * b * b >> 8);
    }

    public String toString() {
        return this.r + "R " + this.g + "G " + this.b + "B " + this.a + "A";
    }
}

