/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class SimpleInventory
implements INBTInventory,
WorldlyContainer {
    protected final ItemStack[] contents;
    private final int stackLimit;
    private final List<IDirtyMarkListener> dirtyMarkListeners = Lists.newLinkedList();
    private int hash;

    public SimpleInventory() {
        this(0, 0);
    }

    public SimpleInventory(int size, int stackLimit) {
        this.contents = new ItemStack[size];
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = ItemStack.f_41583_;
        }
        this.stackLimit = stackLimit;
    }

    public synchronized void addDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.add(dirtyMarkListener);
    }

    public synchronized void removeDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.remove(dirtyMarkListener);
    }

    public int m_6643_() {
        return this.contents.length;
    }

    public ItemStack m_8020_(int slotId) {
        return this.contents[slotId];
    }

    public ItemStack m_7407_(int slotId, int count) {
        ItemStack stack = this.m_8020_(slotId);
        if (slotId < this.m_6643_() && !stack.m_41619_()) {
            if (stack.m_41613_() > count) {
                ItemStack slotContents = stack.m_41777_();
                ItemStack result = slotContents.m_41620_(count);
                this.m_6836_(slotId, slotContents);
                return result;
            }
            this.m_6836_(slotId, ItemStack.f_41583_);
            this.onInventoryChanged();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slotId, ItemStack itemstack) {
        if (slotId >= this.m_6643_()) {
            return;
        }
        this.contents[slotId] = Objects.requireNonNull(itemstack);
        if (!itemstack.m_41619_() && itemstack.m_41613_() > this.m_6893_()) {
            itemstack.m_41764_(this.m_6893_());
        }
        this.onInventoryChanged();
    }

    public int m_6893_() {
        return this.stackLimit;
    }

    protected void onInventoryChanged() {
        this.m_6596_();
    }

    public boolean m_6542_(Player entityplayer) {
        return true;
    }

    public void m_5856_(Player playerIn) {
    }

    public void m_5785_(Player playerIn) {
    }

    @Override
    public void read(CompoundTag data) {
        this.readFromNBT(data, "items");
    }

    public void readFromNBT(CompoundTag data, String tag) {
        int j;
        ListTag nbttaglist = data.m_128437_(tag, 10);
        for (j = 0; j < this.m_6643_(); ++j) {
            this.contents[j] = ItemStack.f_41583_;
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            CompoundTag slot = nbttaglist.m_128728_(j);
            int index = slot.m_128441_("index") ? slot.m_128451_("index") : (int)slot.m_128445_("Slot");
            if (index < 0 || index >= this.m_6643_()) continue;
            this.contents[index] = ItemStack.m_41712_((CompoundTag)slot);
        }
    }

    @Override
    public void write(CompoundTag data) {
        this.writeToNBT(data, "items");
    }

    public void writeToNBT(CompoundTag data, String tag) {
        ListTag slots = new ListTag();
        for (byte index = 0; index < this.m_6643_(); index = (byte)((byte)(index + 1))) {
            ItemStack itemStack = this.m_8020_(index);
            if (itemStack.m_41619_() || itemStack.m_41613_() <= 0) continue;
            CompoundTag slot = new CompoundTag();
            slots.add((Object)slot);
            slot.m_128344_("Slot", index);
            itemStack.m_41739_(slot);
        }
        data.m_128365_(tag, (Tag)slots);
    }

    public ItemStack m_8016_(int slotId) {
        ItemStack stackToTake = this.m_8020_(slotId);
        if (stackToTake.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.m_6836_(slotId, ItemStack.f_41583_);
        return stackToTake;
    }

    public ItemStack[] getItemStacks() {
        return this.contents;
    }

    public boolean m_7013_(int i, ItemStack itemstack) {
        return i < this.m_6643_() && i >= 0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.contents[i] = ItemStack.f_41583_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6596_() {
        LinkedList dirtyMarkListeners;
        ++this.hash;
        SimpleInventory simpleInventory = this;
        synchronized (simpleInventory) {
            dirtyMarkListeners = Lists.newLinkedList(this.dirtyMarkListeners);
        }
        for (IDirtyMarkListener dirtyMarkListener : dirtyMarkListeners) {
            dirtyMarkListener.onDirty();
        }
    }

    @Override
    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        this.write(tag);
        return tag;
    }

    @Override
    public void fromNBT(CompoundTag tag) {
        this.read(tag);
    }

    public IItemHandler getItemHandler() {
        return new InvWrapper((Container)this);
    }

    public IItemHandler getItemHandlerSided(Direction side) {
        return new SidedInvWrapper((WorldlyContainer)this, side);
    }

    public int getState() {
        return this.hash;
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }
}

