/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.location;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.api.codec.CodecExtensions;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public final class PreciseDimensionalPosition
implements IDimensionalPosition {
    public static final Codec<PreciseDimensionalPosition> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("dim").forGetter(PreciseDimensionalPosition::dimension), (App)CodecExtensions.VECTOR3D.fieldOf("pos").forGetter(PreciseDimensionalPosition::position), (App)CodecExtensions.VECTOR3D.optionalFieldOf("rot", (Object)Vec3.f_82478_).forGetter(x -> x.rotation)).apply((Applicative)i, PreciseDimensionalPosition::new));
    private final ResourceKey<Level> dimension;
    private final Vec3 position;
    private final Vec3 rotation;

    public PreciseDimensionalPosition(ResourceKey<Level> dimension, Vec3 position) {
        this.dimension = dimension;
        this.position = position;
        this.rotation = Vec3.f_82478_;
    }

    public PreciseDimensionalPosition(ResourceKey<Level> dimension, Vec3 position, Vec3 rotation) {
        this.dimension = dimension;
        this.position = position;
        this.rotation = rotation;
    }

    public static PreciseDimensionalPosition fromPlayer(Player player) {
        return new PreciseDimensionalPosition((ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20182_(), player.m_20154_());
    }

    @Override
    public BlockPos getBlockPosition() {
        return new BlockPos((int)this.position.f_82479_, (int)this.position.f_82480_, (int)this.position.f_82481_);
    }

    @Override
    public Vec3 getExactPosition() {
        return this.position;
    }

    public Optional<Vec3> rotation() {
        return Optional.ofNullable(this.rotation);
    }

    @Override
    public ResourceKey<Level> dimensionKey() {
        return this.dimension;
    }

    @Override
    public ServerLevel level(MinecraftServer server) {
        return server.m_129880_(this.dimension);
    }

    @Override
    public IDimensionalPosition relative(Direction direction) {
        Vec3 newPos = this.position.m_82520_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
        return new PreciseDimensionalPosition(this.dimension, newPos);
    }

    @Override
    public Optional<Vec2> getRotation() {
        return Optional.empty();
    }

    @Override
    public boolean isLoaded(MinecraftServer serv) {
        return this.level(serv).m_46749_(this.getBlockPosition());
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public Vec3 position() {
        return this.position;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PreciseDimensionalPosition that = (PreciseDimensionalPosition)obj;
        return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.position);
    }

    public String toString() {
        return "PreciseDimensionalPosition[dimension=" + this.dimension + ", position=" + this.position + "]";
    }
}

