/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.item.faulty;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import stone.mae2.MAE2;
import stone.mae2.item.faulty.FaultyCardMode;
import stone.mae2.util.TransHelper;

public class AoEPaste
extends FaultyCardMode {
    private static final String RADIUS = "radius";
    private static final int MAX_RADIUS = 7;
    private byte radius = 1;

    @Override
    protected FaultyCardMode load(CompoundTag tag) {
        this.radius = tag.m_128445_(RADIUS);
        return this;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        CompoundTag data = super.save(tag);
        data.m_128344_(RADIUS, this.radius);
        return data;
    }

    @Override
    public InteractionResultHolder<ItemStack> onItemUse(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        this.radius = (byte)(this.radius >= 7 ? 1 : this.radius + 1);
        this.save(stack.m_41784_());
        player.m_5661_((Component)Component.m_237110_((String)TransHelper.GUI.toKey("faulty", RADIUS), (Object[])new Object[]{2 * this.radius + 1}), true);
        MAE2.LOGGER.info("Radius: {}/{}", (Object)this.radius, (Object)7);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        BlockEntity be = level.m_7702_(context.m_8083_());
        if (be instanceof IPartHost) {
            Item item;
            IPartHost partHost = (IPartHost)be;
            SelectedPart selectedPart = partHost.selectPartWorld(context.m_43720_());
            if (selectedPart.part != null && selectedPart.side != null && (item = stack.m_41720_()) instanceof IMemoryCard) {
                IMemoryCard card = (IMemoryCard)item;
                CompoundTag data = card.getData(stack);
                byte x = selectedPart.side.m_122429_() != 0 ? (byte)0 : 1;
                byte y = selectedPart.side.m_122430_() != 0 ? (byte)0 : 1;
                byte z = selectedPart.side.m_122431_() != 0 ? (byte)0 : 1;
                BlockPos clicked = context.m_8083_().m_7949_();
                for (int i = -this.radius * x; i <= this.radius * x; ++i) {
                    for (int j = -this.radius * y; j <= this.radius * y; ++j) {
                        for (int k = -this.radius * z; k <= this.radius * z; ++k) {
                            IPartHost aoePartHost;
                            IPart part;
                            BlockEntity aoeBE = level.m_7702_(clicked.m_7918_(i, j, k));
                            MAE2.LOGGER.info("Iterated over Faulty Card!");
                            if (!(aoeBE instanceof IPartHost) || (part = (aoePartHost = (IPartHost)aoeBE).getPart(selectedPart.side)) == null) continue;
                            part.onActivate(context.m_43723_(), context.m_43724_(), context.m_43720_());
                        }
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public ResourceLocation getType() {
        return MAE2.toKey("aoe_paste");
    }

    @Override
    public int getTintColor() {
        return 0xFF000000 | 0x111111 * (int)(15.0 * ((double)this.radius / 7.0));
    }

    @Override
    protected Component getName() {
        return Component.m_237110_((String)TransHelper.GUI.toKey("faulty", "aoe"), (Object[])new Object[]{2 * this.radius + 1});
    }
}

