/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.client.render.crafting;

import appeng.block.crafting.ICraftingUnitType;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.LightBakedModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import stone.mae2.block.crafting.DynamicCraftingUnitType;

public class DynamicCraftingCubeModelProvider
extends AbstractCraftingUnitModelProvider<DynamicCraftingUnitType> {
    public static final ChunkRenderTypeSet CUTOUT = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    private static final List<Material> MATERIALS = new ArrayList<Material>();
    protected static final Material RING_CORNER = DynamicCraftingCubeModelProvider.texture("mae2", "ring_corner");
    protected static final Material RING_SIDE_HOR = DynamicCraftingCubeModelProvider.texture("mae2", "ring_side_hor");
    protected static final Material RING_SIDE_VER = DynamicCraftingCubeModelProvider.texture("mae2", "ring_side_ver");
    protected static final Material LIGHT_BASE = DynamicCraftingCubeModelProvider.texture("mae2", "light_base");
    protected static final Material ACCELERATOR_4x_LIGHT = DynamicCraftingCubeModelProvider.texture("mae2", "4x_accelerator_light");
    protected static final Material ACCELERATOR_16x_LIGHT = DynamicCraftingCubeModelProvider.texture("mae2", "16x_accelerator_light");
    protected static final Material ACCELERATOR_64x_LIGHT = DynamicCraftingCubeModelProvider.texture("mae2", "64x_accelerator_light");
    protected static final Material ACCELERATOR_256x_LIGHT = DynamicCraftingCubeModelProvider.texture("mae2", "256x_accelerator_light");

    public DynamicCraftingCubeModelProvider(DynamicCraftingUnitType type) {
        super((ICraftingUnitType)type);
    }

    public List<Material> getMaterials() {
        return Collections.unmodifiableList(MATERIALS);
    }

    public BakedModel getBakedModel(Function<Material, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite ringCorner = spriteGetter.apply(RING_CORNER);
        TextureAtlasSprite ringSideHor = spriteGetter.apply(RING_SIDE_HOR);
        TextureAtlasSprite ringSideVer = spriteGetter.apply(RING_SIDE_VER);
        return new LightBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(LIGHT_BASE), this.getLightMaterial(spriteGetter)){

            public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
                return CUTOUT;
            }
        };
    }

    public TextureAtlasSprite getLightMaterial(Function<Material, TextureAtlasSprite> textureGetter) {
        return switch ((DynamicCraftingUnitType)this.type) {
            case DynamicCraftingUnitType.ACCELERATOR_4x -> textureGetter.apply(ACCELERATOR_4x_LIGHT);
            case DynamicCraftingUnitType.ACCELERATOR_16x -> textureGetter.apply(ACCELERATOR_16x_LIGHT);
            case DynamicCraftingUnitType.ACCELERATOR_64x -> textureGetter.apply(ACCELERATOR_64x_LIGHT);
            case DynamicCraftingUnitType.ACCELERATOR_256x -> textureGetter.apply(ACCELERATOR_256x_LIGHT);
            default -> throw new IllegalArgumentException("Crafting unit type " + String.valueOf(this.type) + " does not use a light texture.");
        };
    }

    private static Material texture(String namespace, String name) {
        Material mat = new Material(TextureAtlas.f_118259_, new ResourceLocation(namespace, "block/crafting/" + name));
        MATERIALS.add(mat);
        return mat;
    }
}

