/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.xnet.multiblock.WorldBlob;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class XNetBlobData
extends AbstractWorldData<XNetBlobData> {
    private static final String NAME = "XNetBlobData";
    private final Map<ResourceKey<Level>, WorldBlob> worldBlobMap = new HashMap<ResourceKey<Level>, WorldBlob>();

    public XNetBlobData() {
    }

    public XNetBlobData(CompoundTag tag) {
        if (tag.m_128441_("worlds")) {
            ListTag worlds = (ListTag)tag.m_128423_("worlds");
            for (Tag world : worlds) {
                CompoundTag tc = (CompoundTag)world;
                ResourceKey dim = LevelTools.getId((String)tc.m_128461_("dimtype"));
                WorldBlob blob = new WorldBlob((ResourceKey<Level>)dim);
                blob.readFromNBT(tc);
                this.worldBlobMap.put((ResourceKey<Level>)dim, blob);
            }
        }
    }

    @Nonnull
    public static XNetBlobData get(Level world) {
        return (XNetBlobData)XNetBlobData.getData((Level)world, XNetBlobData::new, XNetBlobData::new, (String)NAME);
    }

    public WorldBlob getWorldBlob(Level world) {
        return this.getWorldBlob((ResourceKey<Level>)world.m_46472_());
    }

    public WorldBlob getWorldBlob(ResourceKey<Level> type) {
        if (!this.worldBlobMap.containsKey(type)) {
            this.worldBlobMap.put(type, new WorldBlob(type));
        }
        return this.worldBlobMap.get(type);
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        ListTag list = new ListTag();
        for (Map.Entry<ResourceKey<Level>, WorldBlob> entry : this.worldBlobMap.entrySet()) {
            WorldBlob blob = entry.getValue();
            CompoundTag tc = new CompoundTag();
            tc.m_128359_("dimtype", blob.getDimensionType().m_135782_().toString());
            blob.writeToNBT(tc);
            list.add((Object)tc);
        }
        compound.m_128365_("worlds", (Tag)list);
        return compound;
    }
}

