/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;

public record IntPos(int pos) {
    public static int CURRENT_VERSION = 1;

    public IntPos(BlockPos pos) {
        this(IntPos.toInt(pos));
    }

    public int[] getSidePositions() {
        return new int[]{this.posDown(), this.posUp(), this.posEast(), this.posWest(), this.posSouth(), this.posNorth()};
    }

    public IntPos upgrade(int version) {
        if (version != CURRENT_VERSION) {
            return new IntPos(new BlockPos(this.getX(), this.getYOld(), this.getZOld()));
        }
        return this;
    }

    public boolean isBorder() {
        return this.getX() == 0 || this.getX() == 15 || this.getZ() == 0 || this.getZ() == 15;
    }

    public boolean isBorder(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> false;
            case Direction.NORTH -> {
                if (this.getZ() == 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (this.getZ() == 15) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (this.getX() == 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> this.getX() == 15;
        };
    }

    public IntPos otherSide(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> this;
            case Direction.NORTH -> new IntPos(this.pos + 240);
            case Direction.SOUTH -> new IntPos(this.pos - 240);
            case Direction.WEST -> new IntPos(this.pos + 15);
            case Direction.EAST -> new IntPos(this.pos - 15);
        };
    }

    public int getX() {
        return this.pos & 0xF;
    }

    public int getYOld() {
        return this.pos >> 4 & 0xFF;
    }

    public int getY() {
        return (this.pos >> 8 & 0xFFFF) - 32768;
    }

    public int getZOld() {
        return this.pos >> 12 & 0xF;
    }

    public int getZ() {
        return this.pos >> 4 & 0xF;
    }

    public int posSouth() {
        if (this.getZ() >= 15) {
            return -1;
        }
        return this.pos + 16;
    }

    public int posNorth() {
        if (this.getZ() < 1) {
            return -1;
        }
        return this.pos - 16;
    }

    public int posEast() {
        if (this.getX() >= 15) {
            return -1;
        }
        return this.pos + 1;
    }

    public int posWest() {
        if (this.getX() < 1) {
            return -1;
        }
        return this.pos - 1;
    }

    public int posUp() {
        if (this.getY() >= Short.MAX_VALUE) {
            return -1;
        }
        return this.pos + 256;
    }

    public int posDown() {
        if (this.getY() < -32767) {
            return -1;
        }
        return this.pos - 256;
    }

    private static int toInt(BlockPos pos) {
        int dx = pos.m_123341_() & 0xF;
        int dy = pos.m_123342_() + 32768;
        int dz = pos.m_123343_() & 0xF;
        return dz << 4 | dy << 8 | dx;
    }

    public BlockPos toBlockPos(ChunkPos cpos) {
        int dx = this.getX();
        int dy = this.getY();
        int dz = this.getZ();
        return new BlockPos((cpos.f_45578_ << 4) + dx, dy, (cpos.f_45579_ << 4) + dz);
    }
}

