/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat;

import java.util.ArrayList;
import java.util.Collections;
import mcjty.lib.varia.Tools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public final class ForestrySupport {
    private static final String ID = "forestry";
    private static final String QUEEN_BEE = "forestry:bee_queen_ge";
    private static final String PRINCESS_BEE = "forestry:bee_princess_ge";
    private static final String DRONE_BEE = "forestry:bee_drone_ge";
    private static final String LARVAE_BEE = "forestry:bee_larvae_ge";
    private static final String SAPLING = "forestry:sapling";
    private static final String POLLEN = "forestry:pollen_fertile";
    private static final String BUTTERFLY = "forestry:butterfly_ge";
    private static final String SERUM = "forestry:serum_ge";
    private static final String CATERPILLAR = "forestry:caterpillar_ge";
    private static final String COCOON = "forestry:cocoon_ge";
    private static final String[] FORESTRY_NAMES = new String[]{"forestry:bee_queen_ge", "forestry:bee_princess_ge", "forestry:bee_drone_ge", "forestry:bee_larvae_ge", "forestry:sapling", "forestry:pollen_fertile", "forestry:butterfly_ge", "forestry:serum_ge", "forestry:caterpillar_ge", "forestry:cocoon_ge"};

    public static boolean isLoaded() {
        return ModList.get().isLoaded(ID);
    }

    public static boolean isBreedable(ItemStack item) {
        String itemName = Tools.getId((ItemStack)item).toString();
        for (String forestryName : FORESTRY_NAMES) {
            if (!itemName.equals(forestryName)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack sanitize(ItemStack item, int flags) {
        CompoundTag tagCompound = item.m_41783_().m_6426_();
        ArrayList<Tag> tagsToRemove = new ArrayList<Tag>();
        switch (Tools.getId((ItemStack)item).toString()) {
            case "forestry:bee_queen_ge": 
            case "forestry:bee_princess_ge": {
                tagsToRemove.add(Tag.GEN);
            }
            case "forestry:bee_drone_ge": 
            case "forestry:bee_larvae_ge": {
                Collections.addAll(tagsToRemove, Tag.GENOME, Tag.MATE, Tag.HEALTH, Tag.IS_ANALYZED, Tag.MAX_HEALTH);
                item.m_41751_(ForestrySupport.removeTags(tagsToRemove, tagCompound, flags));
                break;
            }
            case "forestry:sapling": 
            case "forestry:pollen_fertile": {
                Collections.addAll(tagsToRemove, Tag.GENOME, Tag.IS_ANALYZED);
                item.m_41751_(ForestrySupport.removeTags(tagsToRemove, tagCompound, flags));
                break;
            }
            case "forestry:butterfly_ge": 
            case "forestry:serum_ge": 
            case "forestry:caterpillar_ge": 
            case "forestry:cocoon_ge": {
                Collections.addAll(tagsToRemove, Tag.GENOME, Tag.MATE, Tag.HEALTH, Tag.IS_ANALYZED, Tag.MAX_HEALTH, Tag.AGE);
                item.m_41751_(ForestrySupport.removeTags(tagsToRemove, tagCompound, flags));
                break;
            }
            default: {
                throw new IllegalArgumentException("Tried to sanitize \"" + Tools.getId((ItemStack)item).toString() + "\" for Forestry!");
            }
        }
        return item;
    }

    private static CompoundTag removeTags(Iterable<Tag> tagsToRemove, CompoundTag compound, int flags) {
        for (Tag tag : tagsToRemove) {
            if ((flags & tag.flag) != tag.flag || !compound.m_128441_(tag.name)) continue;
            compound.m_128473_(tag.name);
        }
        return compound;
    }

    public static enum Tag {
        GENOME("Genome", 1),
        MATE("Mate", 2),
        GEN("GEN", 4),
        HEALTH("Health", 8),
        IS_ANALYZED("IsAnalyzed", 16),
        MAX_HEALTH("MaxH", 32),
        AGE("Age", 64);

        private final String name;
        private final int flag;

        private Tag(String name, int flag) {
            this.name = name;
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }
    }
}

