/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import java.util.Map;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.xnet.apiimpl.logic.enums.LogicFilter;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.nbt.CompoundTag;

public class RSOutput {
    private boolean isAdvanced;
    private LogicFilter logicFilter = LogicFilter.DIRECT;
    private Color inputChannel1 = Color.OFF;
    private Color inputChannel2 = Color.OFF;
    private int redstoneOut = 0;
    private boolean flipFlapState = false;
    private boolean lastInputTrue = false;
    private boolean impulse = false;
    private int impulseDuration = 1;
    private int impulseRemaining = 0;
    private int countingHolder = 0;
    private int countingCurrent = 0;
    private int ticksHolder = 5;
    private int ticksCurrent = 5;

    public RSOutput(boolean isAdvanced) {
        this.isAdvanced = isAdvanced;
    }

    public LogicFilter getLogicFilter() {
        return this.logicFilter;
    }

    public Color getInputChannel1() {
        return this.inputChannel1;
    }

    public Color getInputChannel2() {
        return this.inputChannel2;
    }

    public int getRedstoneOut() {
        return this.redstoneOut;
    }

    public int getCountingHolder() {
        return this.countingHolder;
    }

    public int getTicksHolder() {
        return this.ticksHolder;
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public boolean isFlipFlapState() {
        return this.flipFlapState;
    }

    public boolean isLastInputTrue() {
        return this.lastInputTrue;
    }

    public int getCountingCurrent() {
        return this.countingCurrent;
    }

    public int getTicksCurrent() {
        return this.ticksCurrent;
    }

    protected void setAdvanced(boolean advanced) {
        this.isAdvanced = advanced;
    }

    public void setFlipFlapState(boolean flipFlapState) {
        this.flipFlapState = flipFlapState;
    }

    public void setLastInputTrue(boolean lastInputTrue) {
        this.lastInputTrue = lastInputTrue;
    }

    public void setCountingCurrent(int countingCurrent) {
        this.countingCurrent = countingCurrent;
    }

    public void setTicksCurrent(int ticksCurrent) {
        this.ticksCurrent = ticksCurrent;
    }

    public void setCountingHolder(int countingHolder) {
        this.countingHolder = countingHolder;
        this.countingCurrent = countingHolder;
    }

    public void setTicksHolder(int ticksHolder) {
        this.ticksHolder = ticksHolder;
        this.ticksCurrent = ticksHolder;
    }

    public void setLogicFilter(LogicFilter logicFilter) {
        this.logicFilter = logicFilter;
    }

    public void setInputChannel1(Color inputChannel1) {
        this.inputChannel1 = inputChannel1;
    }

    public void setInputChannel2(Color inputChannel2) {
        this.inputChannel2 = inputChannel2;
    }

    public void setRedstoneOut(int redstoneOut) {
        this.redstoneOut = redstoneOut;
    }

    public boolean isImpulse() {
        return this.impulse;
    }

    public void setImpulse(boolean impulse) {
        this.impulse = impulse;
    }

    public int getImpulseDuration() {
        return this.impulseDuration;
    }

    public void setImpulseDuration(int impulseDuration) {
        this.impulseDuration = impulseDuration;
    }

    public int getImpulseRemaining() {
        return this.impulseRemaining;
    }

    public boolean decreaseImpulseRemaining() {
        if (this.impulseRemaining > 0) {
            --this.impulseRemaining;
            return true;
        }
        return false;
    }

    public void setAndDecreaseImpulseRemaining() {
        this.impulseRemaining = this.impulseDuration;
        --this.impulseRemaining;
        this.lastInputTrue = true;
    }

    public void setImpulseRemaining(int impulseRemaining) {
        this.impulseRemaining = impulseRemaining;
    }

    public void createGui(IEditorGui gui) {
        if (gui.isAdvanced()) {
            gui.translatableChoices("RSFilter", (ITranslatableEnum)this.logicFilter, (ITranslatableEnum[])LogicFilter.values());
            this.logicFilter.createGui(this, gui);
        } else {
            gui.label(I18nConstants.LOGIC_RS_LABEL.i18n(new Object[0]));
            gui.colors("RSChannel1", I18nConstants.LOGIC_INPUT_CHANNEL_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.inputChannel1.getColor()), Color.COLORS);
            gui.integer("rsout", I18nConstants.LOGIC_RS_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.redstoneOut), 30, 15, 0).nl();
        }
    }

    public void update(Map<String, Object> data) {
        this.logicFilter = CastTools.safeLogicFilter(data.get("RSFilter"));
        this.inputChannel1 = CastTools.safeColor(data.get("RSChannel1"));
        this.inputChannel2 = CastTools.safeColor(data.get("RSChannel2"));
        this.countingHolder = CastTools.safeIntOrValue(data.get("RSCounter"), this.countingHolder);
        this.ticksHolder = CastTools.safeIntOrValue(data.get("RSTimer"), this.ticksHolder);
        this.redstoneOut = CastTools.safeIntOrValue(data.get("rsout"), this.redstoneOut);
        this.impulse = CastTools.safeBoolean(data.get("impulse"));
        this.impulseDuration = CastTools.safeIntOrValue(data.get("impulseDuration"), 1);
        this.impulseRemaining = CastTools.safeInt(data.get("impulseRemaining"));
    }

    public boolean isEnabled(String tag) {
        switch (tag) {
            case "RSFilter": 
            case "rsout": 
            case "RSChannel1": 
            case "RSChannel2": 
            case "RSCounter": 
            case "RSTimer": 
            case "impulse": {
                return true;
            }
            case "impulseDuration": {
                return this.impulse;
            }
        }
        return false;
    }

    public void readFromNBT(CompoundTag tag) {
        this.logicFilter = LogicFilter.values()[tag.m_128445_("RSFilter")];
        this.inputChannel1 = Color.values()[tag.m_128445_("RSChannel1")];
        this.inputChannel2 = Color.values()[tag.m_128445_("RSChannel2")];
        this.setCountingHolder(tag.m_128451_("RSCountingHolder"));
        this.setTicksHolder(tag.m_128451_("RSTicksHolder"));
        this.redstoneOut = tag.m_128451_("rsout");
        this.impulse = tag.m_128471_("impulse");
        this.impulseDuration = tag.m_128451_("impulseDuration");
        this.impulseRemaining = tag.m_128451_("impulseRemaining");
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128344_("RSFilter", (byte)this.logicFilter.ordinal());
        tag.m_128344_("RSChannel1", (byte)this.inputChannel1.ordinal());
        tag.m_128344_("RSChannel2", (byte)this.inputChannel2.ordinal());
        tag.m_128405_("RSCountingHolder", this.countingHolder);
        tag.m_128405_("RSTicksHolder", this.ticksHolder);
        tag.m_128405_("rsout", this.redstoneOut);
        tag.m_128379_("impulse", this.impulse);
        tag.m_128405_("impulseDuration", this.impulseDuration);
        tag.m_128405_("impulseRemaining", this.impulseRemaining);
    }
}

