/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor2.simulation.java;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.roguelogix.biggerreactors.multiblocks.reactor2.simulation.SimulationDescription;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class ReferenceSimulation {
    public ReferenceSimulation(SimulationDescription description) {
    }

    void tick() {
    }

    private record RadiationPacket(double neutronIntensity, double neutronHardness, double neutronSpread) {
    }

    private static class FuelTank {
        long totalCapacity;
        long totalAmount;
        Object2ObjectOpenHashMap<Fuel, Container> fuels = new Object2ObjectOpenHashMap();

        private FuelTank() {
        }

        private class Container {
            Fuel fuel;
            FuelAmount fuelAmount = new FuelAmount(0L, 0L);

            private Container() {
            }

            BurnResult burn(ControlRod controlRod) {
                int i;
                if (!this.fuel.burnable) {
                    return new BurnResult(0.0, 0.0, 0.0, 0.0, (List<Pair<Fuel, FuelAmount>>)new ObjectArrayList(), new FuelAmount(0.0));
                }
                double fertility = controlRod.fertility / (double)FuelTank.this.totalAmount;
                double temp = controlRod.temperature;
                double insertion = controlRod.actual;
                double fuelAmount = this.fuelAmount.fpAmount() / (double)FuelTank.this.totalCapacity;
                double[] exp = new double[4];
                double[] curve = new double[4];
                double[] linear = new double[4];
                double[][] output = new double[4][4];
                for (i = 0; i < 4; ++i) {
                    exp[i] = fertility * this.fuel.reactionProperties[0][0] + temp * this.fuel.reactionProperties[1][0] * insertion * this.fuel.reactionProperties[2][0] + fuelAmount * this.fuel.reactionProperties[3][0];
                }
                for (i = 0; i < 4; ++i) {
                    exp[i] = this.fuel.reactionProperties[4][0] * Math.exp(this.fuel.reactionProperties[5][0] * (exp[i] - this.fuel.reactionProperties[6][0])) + this.fuel.reactionProperties[7][0];
                }
                for (i = 0; i < 4; ++i) {
                    curve[i] = fertility * this.fuel.reactionProperties[8][i] + temp * this.fuel.reactionProperties[9][i] * insertion * this.fuel.reactionProperties[10][i] + fuelAmount * this.fuel.reactionProperties[11][i];
                }
                for (i = 0; i < 4; ++i) {
                    curve[i] = this.fuel.reactionProperties[12][i] * Math.exp(-1.0 * Math.pow(curve[i] * this.fuel.reactionProperties[13][i] - this.fuel.reactionProperties[14][i], 2.0)) + this.fuel.reactionProperties[15][i];
                }
                for (i = 0; i < 4; ++i) {
                    linear[i] = fertility * this.fuel.reactionProperties[16][i] + temp * this.fuel.reactionProperties[17][i] * insertion * this.fuel.reactionProperties[18][i] + fuelAmount * this.fuel.reactionProperties[19][i];
                }
                for (i = 0; i < 4; ++i) {
                    linear[i] = linear[i] + this.fuel.reactionProperties[20][i];
                }
                for (i = 0; i < 4; ++i) {
                    output[0][i] = exp[0] * this.fuel.reactionProperties[21][i] + exp[1] * this.fuel.reactionProperties[22][i] * exp[2] * this.fuel.reactionProperties[23][i] + exp[3] * this.fuel.reactionProperties[24][i];
                    output[1][i] = curve[0] * this.fuel.reactionProperties[25][i] + curve[1] * this.fuel.reactionProperties[26][i] * curve[2] * this.fuel.reactionProperties[27][i] + curve[3] * this.fuel.reactionProperties[28][i];
                    output[2][i] = linear[0] * this.fuel.reactionProperties[29][i] + linear[1] * this.fuel.reactionProperties[30][i] * linear[2] * this.fuel.reactionProperties[31][i] + linear[3] * this.fuel.reactionProperties[24][i];
                }
                for (i = 0; i < 4; ++i) {
                    output[3][i] = output[0][i] * this.fuel.reactionProperties[33][i] + output[1][i] * this.fuel.reactionProperties[34][i] * output[2][i] * this.fuel.reactionProperties[35][i] + this.fuel.reactionProperties[36][i];
                }
                double burnPercent = output[3][0];
                double intensityPerBurn = output[3][1];
                double hardness = output[3][2];
                double spread = output[3][3];
                double toBurn = burnPercent * this.fuelAmount.fpAmount();
                double heat = toBurn * this.fuel.rfPerBurn;
                double intensity = intensityPerBurn * toBurn;
                FuelAmount burnt = new FuelAmount(toBurn);
                ObjectArrayList byproducts = new ObjectArrayList();
                for (Pair<Fuel, FuelAmount> value : this.fuel.burnResults) {
                    byproducts.add((Object)Pair.of((Object)((Fuel)value.first()), (Object)burnt.multiply((FuelAmount)value.second())));
                }
                return new BurnResult(heat, intensity, hardness, spread, Collections.unmodifiableList(byproducts), burnt);
            }
        }

        private record BurnResult(double heatGenerated, double neutronIntensity, double neutronHardness, double neutronSpread, List<Pair<Fuel, FuelAmount>> byproducts, FuelAmount burnt) {
        }
    }

    private static class Fuel {
        Moderator fuelModerationProperties;
        boolean burnable;
        double rfPerBurn;
        List<Pair<Fuel, FuelAmount>> burnResults = new ObjectArrayList();
        List<Pair<Fuel, FuelAmount>> decayResult = new ObjectArrayList();
        double[][] fertilizationProperties = new double[8][4];
        double[][] reactionProperties = new double[48][4];

        private Fuel() {
        }
    }

    public record FuelAmount(long whole, long fractional) {
        public static final int FRACTIONAL_BITS = 30;
        public static final int FP_FRACTIONAL_BITS = 8;
        public static final long FRACTIONAL_ONE = 0x40000000L;
        public static final double FRACTIONAL_TO_FP = 9.313225746154785E-10;

        public FuelAmount(double amount) {
            this((long)Math.floor(amount), (long)Math.floor((amount - Math.floor(amount)) * 1.073741824E9) >> 22 << 22);
        }

        double fpAmount() {
            return (double)this.whole + (double)this.fractional * 9.313225746154785E-10;
        }

        FuelAmount multiply(FuelAmount other) {
            long newWhole = this.whole * other.whole;
            long newFractional = this.fractional * other.fractional >> 30;
            newFractional += this.whole * other.fractional;
            return new FuelAmount(newWhole, newFractional += other.whole * this.fractional);
        }

        static FuelAmount multiply(FuelAmount a, FuelAmount b) {
            return a.multiply(b);
        }
    }

    private static class ControlRod {
        final double speed = 0.1;
        final double resolution = 0.01;
        double requested = 1.0;
        double actual = 1.0;
        double fertility = 1.0;
        double temperature = 0.0;

        private ControlRod() {
        }

        void request(double newPosition) {
            double requestedChange = newPosition - this.requested;
            requestedChange /= 0.01;
            this.requested += (requestedChange *= 0.01);
        }

        void tick() {
            double toMove = this.requested - this.actual;
            this.actual = toMove = Math.max(Math.min(toMove, 0.1), -0.1);
        }
    }

    private static class Moderator {
        double[][] inputMultipliers = new double[8][];

        private Moderator() {
        }
    }
}

