/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.CommonReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.PassiveReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorType;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.elements.TooltipElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class ActiveReactorTerminalScreen
extends PhosphophylliteScreen<ReactorTerminalContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_terminal_active.png");
    private ReactorState reactorState;
    private final int screenWorkTimeTotal = 400;
    private int screenWorkTime = 0;
    private Fluid coolantFluid = Fluids.f_76191_;
    private Fluid exhaustFluid = Fluids.f_76191_;

    public ActiveReactorTerminalScreen(ReactorTerminalContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title, DEFAULT_TEXTURE, 198, 152);
        this.reactorState = (ReactorState)((ReactorTerminalContainer)this.m_6262_()).getGuiPacket();
        this.coolantFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.reactorState.coolantResourceLocation));
        this.exhaustFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.reactorState.exhaustResourceLocation));
    }

    public void m_7856_() {
        super.m_7856_();
        CommonReactorTerminalScreen.initTooltips(this, this.reactorState);
        this.initTooltips();
        CommonReactorTerminalScreen.initControls(this, this.reactorState);
        CommonReactorTerminalScreen.initGauges(this, this.reactorState);
        this.initGauges();
        CommonReactorTerminalScreen.initSymbols(this, this.reactorState);
        this.initSymbols();
    }

    private void initTooltips() {
        TooltipElement generationRateReadoutTooltip = new TooltipElement((PhosphophylliteScreen)this, 26, 38, 53, 16, (Component)Component.m_237119_());
        generationRateReadoutTooltip.onTick = () -> {
            generationRateReadoutTooltip.tooltip = Component.m_237113_((String)String.format("%.3f mB/t", this.reactorState.reactorOutputRate));
        };
        this.addScreenElement((AbstractElement)generationRateReadoutTooltip);
    }

    private void initGauges() {
        RenderedElement coolantIntakeTank = new RenderedElement((PhosphophylliteScreen)this, 151, 25, 18, 64, 0, 152, (Component)Component.m_237119_());
        coolantIntakeTank.onRender = (graphics, mX, mY) -> CommonRender.renderFluidGauge(graphics, coolantIntakeTank, this.reactorState.coolantStored, this.reactorState.coolantCapacity, this.coolantFluid);
        this.addScreenElement((AbstractElement)coolantIntakeTank);
        RenderedElement hotExhaustTank = new RenderedElement((PhosphophylliteScreen)this, 173, 25, 18, 64, 0, 152, (Component)Component.m_237119_());
        hotExhaustTank.onRender = (graphics, mX, mY) -> CommonRender.renderFluidGauge(graphics, hotExhaustTank, this.reactorState.exhaustStored, this.reactorState.exhaustCapacity, this.exhaustFluid);
        this.addScreenElement((AbstractElement)hotExhaustTank);
        RenderedElement progressBar = new RenderedElement((PhosphophylliteScreen)this, 173, 90, 18, 26, 90, 152, null);
        progressBar.onRender = (graphics, mX, mY) -> {
            if (this.reactorState.coolantStored > 0L) {
                ActiveReactorTerminalScreen.renderProgressBar(graphics, (RenderedElement<ReactorTerminalContainer>)progressBar, this.reactorState.reactorActivity, this.screenWorkTime++, 400, this.coolantFluid);
                if (this.screenWorkTime >= 400) {
                    this.screenWorkTime = 0;
                }
            }
        };
        this.addScreenElement((AbstractElement)progressBar);
    }

    private void initSymbols() {
        RenderedElement coolantIntakeTankSymbol = new RenderedElement((PhosphophylliteScreen)this, 152, 6, 16, 16, 174, 152, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_terminal.coolant_intake_tank.tooltip"));
        coolantIntakeTankSymbol.onRender = (graphics, mX, mY) -> RenderHelper.drawMaskedFluid((GuiGraphics)graphics, (int)coolantIntakeTankSymbol.x, (int)coolantIntakeTankSymbol.y, (int)0, (int)coolantIntakeTankSymbol.width, (int)coolantIntakeTankSymbol.height, (int)coolantIntakeTankSymbol.u, (int)coolantIntakeTankSymbol.v, (Fluid)this.coolantFluid);
        this.addScreenElement((AbstractElement)coolantIntakeTankSymbol);
        RenderedElement hotExhaustTankSymbol = new RenderedElement((PhosphophylliteScreen)this, 174, 6, 16, 16, 158, 152, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_terminal.exhaust_tank.tooltip"));
        hotExhaustTankSymbol.onRender = (graphics, mX, mY) -> RenderHelper.drawMaskedFluid((GuiGraphics)graphics, (int)hotExhaustTankSymbol.x, (int)hotExhaustTankSymbol.y, (int)0, (int)hotExhaustTankSymbol.width, (int)hotExhaustTankSymbol.height, (int)hotExhaustTankSymbol.u, (int)hotExhaustTankSymbol.v, (Fluid)this.exhaustFluid);
        this.addScreenElement((AbstractElement)hotExhaustTankSymbol);
        RenderedElement exhaustGenerationRateSymbol = new RenderedElement((PhosphophylliteScreen)this, 8, 38, 16, 16, 142, 152, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_terminal.exhaust_generation_rate.tooltip"));
        exhaustGenerationRateSymbol.onRender = (graphics, mX, mY) -> RenderHelper.drawMaskedFluid((GuiGraphics)graphics, (int)exhaustGenerationRateSymbol.x, (int)exhaustGenerationRateSymbol.y, (int)0, (int)exhaustGenerationRateSymbol.width, (int)exhaustGenerationRateSymbol.height, (int)exhaustGenerationRateSymbol.u, (int)exhaustGenerationRateSymbol.v, (Fluid)this.exhaustFluid);
        this.addScreenElement((AbstractElement)exhaustGenerationRateSymbol);
    }

    public void m_181908_() {
        this.reactorState = (ReactorState)((ReactorTerminalContainer)this.m_6262_()).getGuiPacket();
        super.m_181908_();
        if (this.reactorState.reactorType != ReactorType.ACTIVE) {
            this.getMinecraft().m_91152_((Screen)new PassiveReactorTerminalScreen((ReactorTerminalContainer)this.f_97732_, this.inventory, this.f_96539_));
        }
        if (!this.reactorState.coolantResourceLocation.equals(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.coolantFluid)).toString())) {
            this.coolantFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.reactorState.coolantResourceLocation));
        }
        if (!this.reactorState.exhaustResourceLocation.equals(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.exhaustFluid)).toString())) {
            this.exhaustFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.reactorState.exhaustResourceLocation));
        }
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        CommonReactorTerminalScreen.renderStatusText(graphics, this, this.reactorState.reactorActivity, this.reactorState.doAutoEject, this.reactorState.fuelHeatStored, this.reactorState.fuelUsageRate, this.reactorState.reactivityRate);
        graphics.m_280056_(this.getFont(), RenderHelper.formatValue((double)(this.reactorState.reactorOutputRate / 1000.0), (String)"B/t"), this.getGuiLeft() + 27, this.getGuiTop() + 42, 0x404040, false);
    }

    private static void renderProgressBar(@Nonnull GuiGraphics graphics, @Nonnull RenderedElement<ReactorTerminalContainer> symbol, ReactorActivity reactorActivity, int workTime, int workTimeTotal, Fluid coolant) {
        if (reactorActivity != ReactorActivity.ACTIVE) {
            workTime = 0;
        }
        if (workTime > 0 && workTimeTotal > 0) {
            int renderSize = symbol.height * workTime / workTimeTotal;
            symbol.blit(graphics, symbol.u + 18, symbol.v);
            symbol.blit(graphics, symbol.width, symbol.height - renderSize, symbol.u, symbol.v);
        }
        RenderHelper.drawMaskedFluid((GuiGraphics)graphics, (int)(symbol.x + 1), (int)(symbol.y + 26), (int)0, (int)16, (int)16, (int)(symbol.u + 36), (int)symbol.v, (Fluid)coolant);
    }
}

