/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.AbstractConfigTag;
import codechicken.lib.config.ConfigCallback;
import codechicken.lib.config.ConfigCategory;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigValue;
import codechicken.lib.config.ConfigValueImpl;
import codechicken.lib.config.ConfigValueList;
import codechicken.lib.config.ConfigValueListImpl;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.quack.collection.StreamableIterable;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigCategoryImpl
extends AbstractConfigTag<ConfigCategory>
implements ConfigCategory {
    static final byte NET_NO_TAG = -1;
    static final byte NET_CAT_TAG = 0;
    static final byte NET_VAL_TAG = 1;
    static final byte NET_VAL_LST = 2;
    private final Map<String, AbstractConfigTag<?>> tagMap = new LinkedHashMap();

    public ConfigCategoryImpl(String name, @Nullable ConfigCategoryImpl parent) {
        super(name, parent);
    }

    @Override
    public boolean has(String name) {
        return this.tagMap.containsKey(name);
    }

    @Override
    @Nullable
    public AbstractConfigTag<?> findTag(String name) {
        return this.tagMap.get(name);
    }

    @Override
    public ConfigCategoryImpl getCategory(String name) {
        ConfigCategoryImpl tag = this.tagMap.get(name);
        if (tag != null && !(tag instanceof ConfigCategory)) {
            throw new IllegalStateException("ConfigTag already exists with key " + name + ", however, is not a category.");
        }
        if (tag == null) {
            tag = new ConfigCategoryImpl(name, this);
            this.tagMap.put(name, tag);
            this.dirty = true;
        }
        return (ConfigCategoryImpl)SneakyUtils.unsafeCast(tag);
    }

    @Override
    @Nullable
    public ConfigCategoryImpl findCategory(String name) {
        ConfigTag existing = this.tagMap.get(name);
        if (!(existing instanceof ConfigCategory)) {
            return null;
        }
        return (ConfigCategoryImpl)SneakyUtils.unsafeCast(existing);
    }

    @Override
    public ConfigValueImpl getValue(String name) {
        ConfigValueImpl tag = this.tagMap.get(name);
        if (tag != null && !(tag instanceof ConfigValue)) {
            throw new IllegalStateException("ConfigTag already exists with key " + name + ", however, is not a value.");
        }
        if (tag == null) {
            tag = new ConfigValueImpl(name, this);
            this.tagMap.put(name, tag);
            this.dirty = true;
        }
        return (ConfigValueImpl)SneakyUtils.unsafeCast(tag);
    }

    @Override
    @Nullable
    public ConfigValueImpl findValue(String name) {
        ConfigTag existing = this.tagMap.get(name);
        if (!(existing instanceof ConfigValue)) {
            return null;
        }
        return (ConfigValueImpl)SneakyUtils.unsafeCast(existing);
    }

    @Override
    public ConfigValueListImpl getValueList(String name) {
        ConfigValueListImpl tag = this.tagMap.get(name);
        if (tag != null && !(tag instanceof ConfigValueList)) {
            throw new IllegalStateException("ConfigTag already exists with key " + name + ", however, is not a List.");
        }
        if (tag == null) {
            tag = new ConfigValueListImpl(name, this);
            this.tagMap.put(name, tag);
            this.dirty = true;
        }
        return (ConfigValueListImpl)SneakyUtils.unsafeCast(tag);
    }

    @Override
    @Nullable
    public ConfigValueListImpl findValueList(String name) {
        ConfigTag existing = this.tagMap.get(name);
        if (!(existing instanceof ConfigValueList)) {
            return null;
        }
        return (ConfigValueListImpl)SneakyUtils.unsafeCast(existing);
    }

    @Override
    public Collection<ConfigTag> getChildren() {
        return Collections.unmodifiableCollection(this.tagMap.values());
    }

    @Override
    public ConfigCategory delete(String name) {
        this.tagMap.remove(name);
        return this;
    }

    @Override
    public void clear() {
        this.tagMap.clear();
    }

    @Override
    public void reset() {
        for (ConfigTag configTag : this.tagMap.values()) {
            configTag.reset();
        }
    }

    @Override
    public ConfigCategory syncTagToClient() {
        for (AbstractConfigTag<?> child : this.tagMap.values()) {
            child.syncTagToClient();
        }
        return (ConfigCategory)super.syncTagToClient();
    }

    @Override
    public boolean requiresClientSync() {
        for (AbstractConfigTag<?> child : this.tagMap.values()) {
            if (!child.requiresClientSync()) continue;
            return true;
        }
        return super.requiresClientSync();
    }

    @Override
    public void runSync(ConfigCallback.Reason reason) {
        super.runSync(reason);
        for (AbstractConfigTag<?> child : this.tagMap.values()) {
            child.runSync(reason);
        }
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || StreamableIterable.of(this.getChildren()).anyMatch(ConfigTag::isDirty);
    }

    @Override
    public void clearDirty() {
        super.clearDirty();
        for (AbstractConfigTag<?> child : this.tagMap.values()) {
            child.clearDirty();
        }
    }

    public ConfigCategoryImpl copy(@Nullable ConfigCategoryImpl parent) {
        ConfigCategoryImpl clone = new ConfigCategoryImpl(this.getName(), parent);
        clone.setComment(List.copyOf(this.getComment()));
        clone.syncToClient = this.syncToClient;
        for (Map.Entry<String, AbstractConfigTag<?>> entry : this.tagMap.entrySet()) {
            clone.tagMap.put(entry.getKey(), entry.getValue().copy(clone));
        }
        return clone;
    }

    @Override
    public void write(MCDataOutput out) {
        out.writeVarInt(this.tagMap.size());
        for (AbstractConfigTag<?> child : this.tagMap.values()) {
            if (!child.requiresClientSync()) {
                out.writeByte(-1);
                continue;
            }
            if (child instanceof ConfigCategory) {
                out.writeByte(0);
            } else if (child instanceof ConfigValue) {
                out.writeByte(1);
            } else if (child instanceof ConfigValueList) {
                out.writeByte(2);
            } else {
                throw new IllegalStateException("Unknown tag class. " + child.getClass());
            }
            out.writeString(child.getName());
            child.write(out);
        }
    }

    @Override
    public void read(MCDataInput in) {
        int numTags = in.readVarInt();
        for (int i = 0; i < numTags; ++i) {
            byte t = in.readByte();
            if (t == -1) continue;
            String name = in.readString();
            ConfigTag tag = this.findTag(name);
            switch (t) {
                default: {
                    throw new IllegalStateException("Unknown tag network type: " + t);
                }
                case 0: {
                    if (tag != null && !(tag instanceof ConfigCategoryImpl)) {
                        throw new IllegalStateException("Tried to read category into " + tag.getClass().getSimpleName());
                    }
                    if (tag != null) break;
                    AbstractConfigTag cat = this.getCategory(name);
                    cat.networkSynthetic = true;
                    tag = cat;
                    break;
                }
                case 1: {
                    if (tag != null && !(tag instanceof ConfigValueImpl)) {
                        throw new IllegalStateException("Tried to read value into " + tag.getClass().getSimpleName());
                    }
                    if (tag != null) break;
                    AbstractConfigTag cat = this.getValue(name);
                    ((ConfigValueImpl)cat).networkSynthetic = true;
                    tag = cat;
                    break;
                }
                case 2: {
                    if (tag != null && !(tag instanceof ConfigValueListImpl)) {
                        throw new IllegalStateException("Tried to read list into " + tag.getClass().getSimpleName());
                    }
                    if (tag != null) break;
                    AbstractConfigTag cat = this.getValueList(name);
                    ((ConfigValueListImpl)cat).networkSynthetic = true;
                    tag = cat;
                }
            }
            tag.read(in);
        }
    }

    @Override
    public void resetFromNetwork() {
        assert (!this.networkSynthetic);
        Iterator<AbstractConfigTag<?>> iterator = this.tagMap.values().iterator();
        while (iterator.hasNext()) {
            AbstractConfigTag<?> child = iterator.next();
            if (child.networkSynthetic) {
                iterator.remove();
                continue;
            }
            child.resetFromNetwork();
        }
    }
}

