/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.gui;

import de.maxhenkel.easyvillagers.corelib.ClientRegistry;
import de.maxhenkel.easyvillagers.gui.AutoTraderContainer;
import de.maxhenkel.easyvillagers.gui.AutoTraderScreen;
import de.maxhenkel.easyvillagers.gui.BreederContainer;
import de.maxhenkel.easyvillagers.gui.BreederScreen;
import de.maxhenkel.easyvillagers.gui.ConverterContainer;
import de.maxhenkel.easyvillagers.gui.ConverterScreen;
import de.maxhenkel.easyvillagers.gui.IncubatorContainer;
import de.maxhenkel.easyvillagers.gui.IncubatorScreen;
import de.maxhenkel.easyvillagers.gui.OutputContainer;
import de.maxhenkel.easyvillagers.gui.OutputScreen;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Containers {
    private static final DeferredRegister<MenuType<?>> MENU_TYPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"easy_villagers");
    public static final RegistryObject<MenuType<AutoTraderContainer>> AUTO_TRADER_CONTAINER = MENU_TYPE_REGISTER.register("auto_trader", () -> IForgeMenuType.create((windowId, inv, data) -> new AutoTraderContainer(windowId, inv)));
    public static final RegistryObject<MenuType<BreederContainer>> BREEDER_CONTAINER = MENU_TYPE_REGISTER.register("breeder", () -> IForgeMenuType.create((windowId, inv, data) -> new BreederContainer(windowId, inv)));
    public static final RegistryObject<MenuType<ConverterContainer>> CONVERTER_CONTAINER = MENU_TYPE_REGISTER.register("converter", () -> IForgeMenuType.create((windowId, inv, data) -> new ConverterContainer(windowId, inv)));
    public static final RegistryObject<MenuType<IncubatorContainer>> INCUBATOR_CONTAINER = MENU_TYPE_REGISTER.register("incubator", () -> IForgeMenuType.create((windowId, inv, data) -> new IncubatorContainer(windowId, inv)));
    public static final RegistryObject<MenuType<OutputContainer>> OUTPUT_CONTAINER = MENU_TYPE_REGISTER.register("output", () -> IForgeMenuType.create((windowId, inv, data) -> new OutputContainer(windowId, inv)));

    public static void init() {
        MENU_TYPE_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup() {
        ClientRegistry.registerScreen((MenuType)AUTO_TRADER_CONTAINER.get(), AutoTraderScreen::new);
        ClientRegistry.registerScreen((MenuType)BREEDER_CONTAINER.get(), BreederScreen::new);
        ClientRegistry.registerScreen((MenuType)CONVERTER_CONTAINER.get(), ConverterScreen::new);
        ClientRegistry.registerScreen((MenuType)INCUBATOR_CONTAINER.get(), IncubatorScreen::new);
        ClientRegistry.registerScreen((MenuType)OUTPUT_CONTAINER.get(), OutputScreen::new);
    }
}

