/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.client;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.client.WeirdRenderThings;
import dev.shadowsoffire.hostilenetworks.curios.CuriosCompat;
import dev.shadowsoffire.hostilenetworks.data.CachedModel;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DeepLearnerItem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class DeepLearnerHudRenderer
implements IGuiOverlay {
    private static final ResourceLocation DL_HUD = new ResourceLocation("hostilenetworks", "textures/gui/deep_learner_hud.png");

    public void render(ForgeGui gui, GuiGraphics gfx, float partialTick, int screenWidth, int screenHeight) {
        CachedModel cModel;
        int i;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !(mc.f_91080_ instanceof ChatScreen) && mc.f_91080_ != null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != Hostile.Items.DEEP_LEARNER.get()) {
            stack = player.m_21206_();
        }
        if (stack.m_41720_() != Hostile.Items.DEEP_LEARNER.get() && ModList.get().isLoaded("curios")) {
            stack = CuriosCompat.getDeepLearner((Player)player);
        }
        if (stack.m_41720_() != Hostile.Items.DEEP_LEARNER.get()) {
            return;
        }
        ItemStackHandler inv = DeepLearnerItem.getItemHandler(stack);
        ArrayList<Pair> renderable = new ArrayList<Pair>(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            CachedModel cModel2;
            ItemStack model = inv.getStackInSlot(i2);
            if (model.m_41619_() || !(cModel2 = new CachedModel(model, 0)).isValid()) continue;
            renderable.add(Pair.of((Object)cModel2, (Object)model));
        }
        if (renderable.isEmpty()) {
            return;
        }
        int spacing = 28;
        int x = 6;
        int y = 6;
        WeirdRenderThings.TRANSLUCENT_TRANSPARENCY.m_110185_();
        gfx.m_280163_(DL_HUD, 3, 3, 0.0f, 23.0f, 113, 1, 256, 256);
        for (i = 0; i < renderable.size(); ++i) {
            gfx.m_280163_(DL_HUD, 3, 4 + spacing * i, 0.0f, 24.0f, 113, spacing, 256, 256);
            cModel = (CachedModel)((Pair)renderable.get(i)).getLeft();
            gfx.m_280163_(DL_HUD, x + 18, y + i * spacing + 10, 0.0f, 0.0f, 89, 12, 256, 256);
            int width = 87;
            if (cModel.getTier() != ModelTier.SELF_AWARE) {
                int prev = cModel.getTierData();
                width = Mth.m_14167_((float)((float)(width * (cModel.getData() - prev)) / (float)(cModel.getNextTierData() - prev)));
            }
            gfx.m_280163_(DL_HUD, x + 19, y + i * spacing + 11, 0.0f, 12.0f, width, 10, 256, 256);
        }
        gfx.m_280163_(DL_HUD, 3, 4 + spacing * renderable.size(), 0.0f, 122.0f, 113, 2, 256, 256);
        WeirdRenderThings.TRANSLUCENT_TRANSPARENCY.m_110188_();
        for (i = 0; i < renderable.size(); ++i) {
            ItemStack dModel = (ItemStack)((Pair)renderable.get(i)).getRight();
            gfx.m_280480_(dModel, x, y + i * spacing + 9);
        }
        for (i = 0; i < renderable.size(); ++i) {
            cModel = (CachedModel)((Pair)renderable.get(i)).getLeft();
            Component comp = cModel.getTier().getComponent();
            gfx.m_280614_(mc.f_91062_, comp, x + 4, y + spacing * i, 0xFFFFFF, true);
            gfx.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"hostilenetworks.hud.model"), x + mc.f_91062_.m_92852_((FormattedText)comp) + 4, y + spacing * i, 0xFFFFFF, true);
            if (cModel.getTier() == ModelTier.SELF_AWARE) continue;
            gfx.m_280056_(mc.f_91062_, I18n.m_118938_((String)"hostilenetworks.hud.kills", (Object[])new Object[]{cModel.getKillsNeeded()}), x + 21, y + 12 + i * spacing, 0xFFFFFF, true);
        }
    }

    public static void drawModel(Minecraft mc, int x, int y, ItemStack stack, CachedModel model, GuiGraphics gfx) {
        gfx.m_280480_(stack, x, y + 9);
        Component comp = model.getTier().getComponent();
        gfx.m_280614_(mc.f_91062_, comp, x + 4, y, 0xFFFFFF, true);
        gfx.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"hostilenetworks.hud.model"), x + mc.f_91062_.m_92852_((FormattedText)comp) + 4, y, 0xFFFFFF, true);
        gfx.m_280163_(DL_HUD, x + 18, y + 10, 0.0f, 0.0f, 89, 12, 256, 256);
        int width = 87;
        if (model.getTier() != ModelTier.SELF_AWARE) {
            width = Mth.m_14167_((float)((float)(width * model.getData()) / (float)model.getNextTierData()));
        }
        gfx.m_280163_(DL_HUD, x + 19, y + 11, 0.0f, 12.0f, width, 10, 256, 256);
    }
}

