/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.registry;

import com.buuz135.industrial.block.IndustrialBlockItem;
import com.buuz135.industrial.module.IModule;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.RegistryObject;
import net.yxiao233.ifeu.common.block.ArcaneDragonEggForgingBlock;
import net.yxiao233.ifeu.common.block.CreativeCapacitorBlock;
import net.yxiao233.ifeu.common.block.DragonGeneratorBlock;
import net.yxiao233.ifeu.common.block.DragonStarGeneratorBlock;
import net.yxiao233.ifeu.common.block.FluidCraftingTableBlock;
import net.yxiao233.ifeu.common.block.FluidTransferBlock;
import net.yxiao233.ifeu.common.block.InfuserBlock;
import net.yxiao233.ifeu.common.block.RuleControllerBlock;
import net.yxiao233.ifeu.common.block.TimeControllerBlock;
import net.yxiao233.ifeu.common.block.WeatherControllerBlock;
import net.yxiao233.ifeu.common.registry.ModItems;
import org.apache.commons.lang3.tuple.Pair;

public class ModBlocks
implements IModule {
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> INFUSER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> DRAGON_STAR_GENERATOR;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> ARCANE_DRAGON_EGG_FORGING;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> CREATIVE_CAPACITOR;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> RULE_CONTROLLER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> WEATHER_CONTROLLER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> TIME_CONTROLLER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> FLUID_CRAFTING_TABLE;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> DRAGON_GENERATOR;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> FLUID_TRANSFER;

    public void generateFeatures(DeferredRegistryHelper helper) {
        INFUSER = this.deferredRegistry(helper, "infuser", InfuserBlock::new);
        DRAGON_STAR_GENERATOR = this.deferredRegistry(helper, "dragon_star_generator", DragonStarGeneratorBlock::new);
        ARCANE_DRAGON_EGG_FORGING = this.deferredRegistry(helper, "arcane_dragon_egg_forging", ArcaneDragonEggForgingBlock::new);
        CREATIVE_CAPACITOR = this.deferredRegistry(helper, "creative_capacitor", CreativeCapacitorBlock::new);
        RULE_CONTROLLER = this.deferredRegistry(helper, "rule_controller", RuleControllerBlock::new);
        WEATHER_CONTROLLER = this.deferredRegistry(helper, "weather_controller", WeatherControllerBlock::new);
        TIME_CONTROLLER = this.deferredRegistry(helper, "time_controller", TimeControllerBlock::new);
        FLUID_CRAFTING_TABLE = this.deferredRegistry(helper, "fluid_crafting_table", FluidCraftingTableBlock::new);
        DRAGON_GENERATOR = this.deferredRegistry(helper, "dragon_generator", DragonGeneratorBlock::new);
        FLUID_TRANSFER = this.deferredRegistry(helper, "fluid_transfer", FluidTransferBlock::new);
    }

    private Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> deferredRegistry(DeferredRegistryHelper helper, String name, Supplier<BasicTileBlock<?>> blockSupplier) {
        return helper.registerBlockWithTileItem(name, blockSupplier, blockRegistryObject -> () -> new IndustrialBlockItem((Block)blockRegistryObject.get(), ModItems.TAB_ADDONS), null);
    }

    public static ArrayList<RegistryObject<Block>> addBlocksToCreativeModeTab() {
        ArrayList<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
        blocks.add((RegistryObject)INFUSER.getLeft());
        blocks.add((RegistryObject)DRAGON_STAR_GENERATOR.getLeft());
        blocks.add((RegistryObject)ARCANE_DRAGON_EGG_FORGING.getLeft());
        blocks.add((RegistryObject)CREATIVE_CAPACITOR.getLeft());
        blocks.add((RegistryObject)RULE_CONTROLLER.getLeft());
        blocks.add((RegistryObject)WEATHER_CONTROLLER.getLeft());
        blocks.add((RegistryObject)TIME_CONTROLLER.getLeft());
        blocks.add((RegistryObject)FLUID_CRAFTING_TABLE.getLeft());
        blocks.add((RegistryObject)DRAGON_GENERATOR.getLeft());
        blocks.add((RegistryObject)FLUID_TRANSFER.getLeft());
        return blocks;
    }
}

