/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.yxiao233.ifeu.common.block.entity.FluidTransferEntity;
import net.yxiao233.ifeu.common.utils.IntArrayBlockPosUtil;
import net.yxiao233.ifeu.common.utils.TooltipHelper;
import org.jetbrains.annotations.Nullable;

public class ConnectToolItem
extends Item {
    public ConnectToolItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!level.m_5776_()) {
            Player player = context.m_43723_();
            BlockPos currentBlockPos = context.m_8083_();
            if (player == null) {
                return super.m_6225_(context);
            }
            ItemStack item = player.m_21205_();
            CompoundTag tag = new CompoundTag();
            CompoundTag emptyTag = new CompoundTag();
            CompoundTag itemTag = item.m_41783_();
            if (level.m_7702_(currentBlockPos) instanceof FluidTransferEntity) {
                this.addPos1ToTag(item, tag, player, currentBlockPos);
                this.addPos2ToTag(item, tag, player, currentBlockPos);
                if (tag.m_128441_("pos2")) {
                    BlockPos blockPos2;
                    BlockPos blockPos1 = tag.m_128441_("pos1") ? this.getBlockPos(tag, "pos1") : this.getBlockPos(item, "pos1");
                    if (blockPos1.equals((Object)(blockPos2 = this.getBlockPos(tag, "pos2")))) {
                        tag = emptyTag;
                        player.m_5661_((Component)Component.m_237115_((String)"message.ifeu.connect_tool.same_pos").m_130940_(ChatFormatting.RED), true);
                    } else {
                        FluidTransferEntity entity1 = this.getFluidTransferEntity(level, blockPos1);
                        FluidTransferEntity entity2 = this.getFluidTransferEntity(level, blockPos2);
                        if (entity1 != null && entity2 != null) {
                            if (ConnectToolItem.getDistance(blockPos1, blockPos2) <= (double)ConnectToolItem.getCanConnectDistance(entity1, entity2)) {
                                entity1.hasConnect = true;
                                entity2.hasConnect = true;
                                entity1.connectBlockPos = blockPos2;
                                entity2.connectBlockPos = blockPos1;
                                player.m_5661_((Component)Component.m_237115_((String)"message.ifeu.connect_tool.connect_success").m_130940_(ChatFormatting.GREEN), true);
                            } else {
                                player.m_5661_((Component)Component.m_237115_((String)"message.ifeu.connect_tool.beyond_distance").m_130940_(ChatFormatting.RED), true);
                            }
                        }
                    }
                }
                if (itemTag != null) {
                    if (!tag.m_128441_("pos1") && itemTag.m_128441_("pos1")) {
                        BlockPos pos1 = this.getBlockPos(item, "pos1");
                        tag.m_128385_("pos1", IntArrayBlockPosUtil.BlockPosToIntArray(pos1));
                    }
                    if (!tag.m_128441_("pos2") && itemTag.m_128441_("pos2")) {
                        BlockPos pos2 = this.getBlockPos(item, "pos2");
                        tag.m_128385_("pos2", IntArrayBlockPosUtil.BlockPosToIntArray(pos2));
                    }
                }
                item.m_41751_(tag);
            }
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_()) {
            BlockHitResult blockHitResult = (BlockHitResult)player.m_19907_(player.getBlockReach(), 0.0f, false);
            if (player.m_6144_() && level.m_8055_(blockHitResult.m_82425_()).m_60795_()) {
                player.m_21205_().m_41751_(new CompoundTag());
                player.m_5661_((Component)Component.m_237115_((String)"message.ifeu.connect_tool.clear_configuration").m_130940_(ChatFormatting.GREEN), true);
                return InteractionResultHolder.m_19090_((Object)player.m_21205_());
            }
        }
        return super.m_7203_(level, player, hand);
    }

    private BlockPos getBlockPos(ItemStack stack, String posId) {
        CompoundTag tag = stack.m_41783_();
        return this.getBlockPos(tag, posId);
    }

    private BlockPos getBlockPos(CompoundTag tag, String posId) {
        if (tag == null) {
            return null;
        }
        if (tag.m_128441_(posId)) {
            int[] temp = tag.m_128465_(posId);
            return new BlockPos((Vec3i)IntArrayBlockPosUtil.intArrayToBlockPos(temp));
        }
        return null;
    }

    private void addPos1ToTag(ItemStack item, CompoundTag tag, Player player, BlockPos pos1) {
        if (!player.m_6144_()) {
            player.m_6144_();
            if (item.m_41783_() != null && !item.m_41783_().m_128441_("pos1")) {
                tag.m_128385_("pos1", IntArrayBlockPosUtil.BlockPosToIntArray(pos1));
                player.m_5661_((Component)Component.m_237110_((String)"message.ifeu.connect_tool.pos1", (Object[])new Object[]{pos1.m_123341_(), pos1.m_123342_(), pos1.m_123343_()}).m_130940_(ChatFormatting.GOLD), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.ifeu.connect_tool.has_pos1").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    private void addPos2ToTag(ItemStack item, CompoundTag tag, Player player, BlockPos pos2) {
        if (player.m_6144_()) {
            if (item.m_41783_() != null && item.m_41783_().m_128441_("pos1")) {
                tag.m_128385_("pos2", IntArrayBlockPosUtil.BlockPosToIntArray(pos2));
                player.m_5661_((Component)Component.m_237110_((String)"message.ifeu.connect_tool.pos2", (Object[])new Object[]{pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_()}).m_130940_(ChatFormatting.GOLD), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.ifeu.connect_tool.no_pos1").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    private FluidTransferEntity getFluidTransferEntity(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof FluidTransferEntity) {
            FluidTransferEntity entity = (FluidTransferEntity)blockEntity;
            return entity;
        }
        return null;
    }

    public static double getDistance(BlockPos pos1, BlockPos pos2) {
        int x1 = pos1.m_123341_();
        int y1 = pos1.m_123342_();
        int z1 = pos1.m_123343_();
        int x2 = pos2.m_123341_();
        int y2 = pos2.m_123342_();
        int z2 = pos2.m_123343_();
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
    }

    public static int getCanConnectDistance(FluidTransferEntity entity1, FluidTransferEntity entity2) {
        return Math.max(entity1.maxConnectionDistance, entity2.maxConnectionDistance);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag isAdvanced) {
        CompoundTag tag = stack.m_41783_();
        TooltipHelper.addTooltipWhileKeyDown(TooltipHelper.KeyType.SHIFT, tooltips, stack, () -> {
            int[] temp;
            if (tag != null && tag.m_128441_("pos1")) {
                temp = tag.m_128465_("pos1");
                TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 0, new Object[]{temp[0], temp[1], temp[2]});
            } else {
                TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.RED, 1);
            }
            if (tag != null && tag.m_128441_("pos2")) {
                temp = tag.m_128465_("pos2");
                TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 2, new Object[]{temp[0], temp[1], temp[2]});
            } else {
                TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.RED, 3);
            }
        });
        TooltipHelper.addTooltipWhileKeyDown(TooltipHelper.KeyType.CONTROL, tooltips, stack, () -> {
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 4);
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 5);
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 6);
        });
        TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.RED, 7);
    }
}

