/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.entity;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.yxiao233.ifeu.common.config.machine.InfuserConfig;
import net.yxiao233.ifeu.common.recipe.InfuserRecipe;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModRecipes;
import org.jetbrains.annotations.NotNull;

public class InfuserEntity
extends IndustrialProcessingTile<InfuserEntity> {
    private int maxProgress;
    private int powerPerTick;
    @Save
    private SidedInventoryComponent<InfuserEntity> input;
    @Save
    private SidedFluidTankComponent<InfuserEntity> inputFluid;
    @Save
    private SidedInventoryComponent<InfuserEntity> output;
    private InfuserRecipe currentRecipe;

    public InfuserEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.INFUSER, 102, 41, blockPos, blockState);
        int slotSpacing = 22;
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("input", 54 + slotSpacing, 18 + slotSpacing, 1, 0).setColor(DyeColor.LIGHT_BLUE).setRange(1, 1).setOutputFilter((itemStack, integer) -> false).setInputFilter((itemStack, integer) -> !this.canIncrease()).setOnSlotChanged((itemStack, integer) -> this.checkForRecipe()).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.input);
        this.inputFluid = (SidedFluidTankComponent)new SidedFluidTankComponent("input_fluid", InfuserConfig.maxInputTankSize, 52, 19, 1).setColor(DyeColor.LIME).setTankType(FluidTankComponent.Type.NORMAL).setComponentHarness((IComponentHarness)this).setOnContentChange(() -> this.checkForRecipe());
        this.addTank((FluidTankComponent)this.inputFluid);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 129, 22, 3, 2).setColor(DyeColor.ORANGE).setRange(1, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.maxProgress = 100;
        this.powerPerTick = InfuserConfig.powerPerTick;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            Item item;
            if (this.currentRecipe != null && this.currentRecipe.matches((IItemHandler)this.input, (FluidTankComponent)this.inputFluid)) {
                return;
            }
            this.currentRecipe = RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)((RecipeType)ModRecipes.INFUSER_TYPE.get())).stream().filter(recipe -> recipe.matches((IItemHandler)this.input, (FluidTankComponent)this.inputFluid)).findFirst().orElse(null);
            if (this.currentRecipe == null && this.input.getStackInSlot(0).m_150930_(Items.f_42446_) && (item = this.inputFluid.getFluid().getFluid().m_6859_()) instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item;
                FluidStack fluidStack = new FluidStack(this.inputFluid.getFluid(), 1000);
                String raw = bucketItem.m_5524_();
                int firstPoint = raw.indexOf(46);
                int lastPoint = raw.lastIndexOf(46);
                String nameSpace = raw.substring(firstPoint + 1, lastPoint);
                String path = raw.substring(lastPoint + 1, raw.length());
                ResourceLocation resourceLocation = new ResourceLocation("ifeu", "infuser/" + nameSpace + "/fill_" + path);
                this.currentRecipe = new InfuserRecipe(resourceLocation, Items.f_42446_.m_7968_(), fluidStack, 200, item.m_7968_());
            }
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.checkForRecipe();
    }

    public void m_142339_(Level p_155231_) {
        super.m_142339_(p_155231_);
        this.checkForRecipe();
    }

    public boolean canIncrease() {
        if (this.currentRecipe != null) {
            boolean hasCurrentItem = ItemHandlerHelper.insertItem(this.output, (ItemStack)this.currentRecipe.output.m_41777_(), (boolean)true).m_41619_();
            boolean hasEnoughCount = this.input.getStackInSlot(0).m_41613_() >= this.currentRecipe.input.m_41613_();
            return hasCurrentItem && hasEnoughCount;
        }
        return false;
    }

    public Runnable onFinish() {
        return () -> {
            if (this.currentRecipe != null) {
                InfuserRecipe infuserRecipe = this.currentRecipe;
                this.input.getStackInSlot(0).m_41774_(infuserRecipe.input.m_41613_());
                this.inputFluid.drainForced(infuserRecipe.inputFluid, IFluidHandler.FluidAction.EXECUTE);
                ItemStack outputStack = infuserRecipe.output.m_41777_();
                outputStack.m_41720_().m_7836_(outputStack, this.f_58857_, null);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)outputStack, (boolean)false);
                this.checkForRecipe();
            }
        };
    }

    @NotNull
    protected EnergyStorageComponent<InfuserEntity> createEnergyStorage() {
        return new EnergyStorageComponent(InfuserConfig.maxStoredPower, 10, 20);
    }

    protected int getTickPower() {
        return this.powerPerTick;
    }

    public int getMaxProgress() {
        return this.currentRecipe != null ? this.currentRecipe.processingTime : this.maxProgress;
    }

    @NotNull
    public InfuserEntity getSelf() {
        return this;
    }
}

