/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.entity;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.LangUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.yxiao233.ifeu.api.components.TextGuiComponent;
import net.yxiao233.ifeu.api.networking.BlockPosSyncS2C;
import net.yxiao233.ifeu.api.networking.BooleanValueSyncS2C;
import net.yxiao233.ifeu.common.block.FluidTransferBlock;
import net.yxiao233.ifeu.common.config.machine.FluidTransferConfig;
import net.yxiao233.ifeu.common.item.ConnectToolItem;
import net.yxiao233.ifeu.common.networking.ModNetWorking;
import net.yxiao233.ifeu.common.networking.packet.BlockPosSyncS2CPacket;
import net.yxiao233.ifeu.common.networking.packet.BooleanSyncS2CPacket;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import org.jetbrains.annotations.NotNull;

public class FluidTransferEntity
extends IndustrialProcessingTile<FluidTransferEntity>
implements BlockPosSyncS2C,
BooleanValueSyncS2C {
    @Save
    public SidedFluidTankComponent<FluidTransferEntity> fluidStored = (SidedFluidTankComponent)new SidedFluidTankComponent("fluid_stored", FluidTransferConfig.maxTankSize, 52, 19, 0).setColor(DyeColor.LIME).setTankType(FluidTankComponent.Type.NORMAL).setComponentHarness((IComponentHarness)this);
    @Save
    public BlockPos connectBlockPos;
    @Save
    public boolean hasConnect;
    @Save
    public boolean mode;
    @Save
    public int maxConnectionDistance;
    @Save
    public boolean isFluidRender = true;
    public ButtonComponent modeComponent;
    public ButtonComponent buttonComponent2;
    public int maxTransfer;

    public FluidTransferEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.FLUID_TRANSFER, 76, 40, blockPos, blockState);
        this.addTank((FluidTankComponent)this.fluidStored);
        this.buttonComponent2 = new ButtonComponent(136, 84, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> {
                    StateButtonInfo[] buttonInfo = new StateButtonInfo[2];
                    IAssetType asset = AssetTypes.BUTTON_SIDENESS_ENABLED;
                    String[] tip = new String[2];
                    ChatFormatting chatFormatting = ChatFormatting.GOLD;
                    tip[0] = chatFormatting + LangUtil.getString((String)"tooltip.ifeu.fluid_crafting_table.render_fluid", (Object[])new Object[0]);
                    tip[1] = "tooltip.ifeu.fluid_crafting_table.render_fluid_1";
                    buttonInfo[0] = new StateButtonInfo(0, asset, tip);
                    asset = AssetTypes.BUTTON_SIDENESS_DISABLED;
                    tip = new String[]{chatFormatting + LangUtil.getString((String)"tooltip.ifeu.fluid_crafting_table.not_render_fluid", (Object[])new Object[0]), "tooltip.ifeu.fluid_crafting_table.not_render_fluid_1"};
                    buttonInfo[1] = new StateButtonInfo(1, asset, tip);
                    return new StateButtonAddon(this, buttonInfo){

                        public int getState() {
                            return FluidTransferEntity.this.isFluidRender ? 0 : 1;
                        }
                    };
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.isFluidRender = !this.isFluidRender;
            this.markForUpdate();
        }).setId(2);
        this.addButton(this.buttonComponent2);
        this.modeComponent = new ButtonComponent(106, 40, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> {
                    StateButtonInfo[] buttonInfo = new StateButtonInfo[2];
                    IAssetType asset = AssetTypes.BUTTON_SIDENESS_ENABLED;
                    String[] tip = new String[2];
                    ChatFormatting chatFormatting = ChatFormatting.GOLD;
                    tip[0] = chatFormatting + LangUtil.getString((String)"tooltip.ifeu.fluid_transfer.input", (Object[])new Object[0]);
                    tip[1] = "tooltip.ifeu.fluid_transfer.input_1";
                    buttonInfo[0] = new StateButtonInfo(0, asset, tip);
                    asset = AssetTypes.BUTTON_SIDENESS_DISABLED;
                    tip = new String[]{chatFormatting + LangUtil.getString((String)"tooltip.ifeu.fluid_transfer.output", (Object[])new Object[0]), "tooltip.ifeu.fluid_transfer.output_1"};
                    buttonInfo[1] = new StateButtonInfo(1, asset, tip);
                    return new StateButtonAddon(this, buttonInfo){

                        public int getState() {
                            return FluidTransferEntity.this.mode ? 0 : 1;
                        }
                    };
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.mode = !this.mode;
            this.markForUpdate();
        }).setId(6);
        this.addButton(this.modeComponent);
        this.maxTransfer = FluidTransferConfig.baseMaxTransfer;
        this.maxConnectionDistance = FluidTransferConfig.defaultMaxConnectDistance;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, FluidTransferEntity blockEntity) {
        Object entity;
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (this.connectBlockPos != null) {
            BlockEntity blockEntity2 = level.m_7702_(this.connectBlockPos);
            if (blockEntity2 instanceof FluidTransferEntity) {
                entity = (FluidTransferEntity)blockEntity2;
                if (entity.hasConnect && this.hasConnect && !entity.connectBlockPos.equals((Object)this.m_58899_())) {
                    this.connectBlockPos = null;
                    this.hasConnect = false;
                }
            } else {
                this.connectBlockPos = null;
                this.hasConnect = false;
            }
        }
        this.getMaxConnectDistance();
        if (this.connectBlockPos != null && (entity = level.m_7702_(this.connectBlockPos)) instanceof FluidTransferEntity) {
            FluidTransferEntity fluidTransferEntity = (FluidTransferEntity)entity;
            if (ConnectToolItem.getDistance(this.m_58899_(), this.connectBlockPos) > (double)ConnectToolItem.getCanConnectDistance(this, fluidTransferEntity)) {
                this.connectBlockPos = null;
                this.hasConnect = false;
            }
        }
        ModNetWorking.sendToClient(new BooleanSyncS2CPacket(this.m_58899_(), this.hasConnect));
        if (this.connectBlockPos != null) {
            ModNetWorking.sendToClient(new BlockPosSyncS2CPacket(this.m_58899_(), this.connectBlockPos));
        }
    }

    public void openGui(Player player) {
        if (!(player.m_21205_().m_41720_() instanceof ConnectToolItem)) {
            super.openGui(player);
        }
    }

    public void getMaxConnectDistance() {
        SidedInventoryComponent augments = this.getAugmentInventory();
        int dis = FluidTransferConfig.defaultMaxConnectDistance;
        for (int i = 0; i < augments.getSlots(); ++i) {
            Item item = augments.getStackInSlot(i).m_41720_();
            if (!(item instanceof RangeAddonItem)) continue;
            RangeAddonItem rangeAddonItem = (RangeAddonItem)item;
            String raw = rangeAddonItem.m_5524_();
            Pattern pattern = Pattern.compile("\\d+");
            Matcher matcher = pattern.matcher(raw);
            int tier = 0;
            if (matcher.find()) {
                tier = Integer.parseInt(matcher.group());
            }
            dis += tier;
            break;
        }
        this.maxConnectionDistance = dis;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new TextGuiComponent(40, 87){

            @Override
            public String getText() {
                if (!FluidTransferEntity.this.hasConnect) {
                    return String.valueOf("Pos: null");
                }
                if (FluidTransferEntity.this.connectBlockPos != null) {
                    int x = FluidTransferEntity.this.connectBlockPos.m_123341_();
                    int y = FluidTransferEntity.this.connectBlockPos.m_123342_();
                    int z = FluidTransferEntity.this.connectBlockPos.m_123343_();
                    return String.valueOf("Pos: " + x + ", " + y + ", " + z);
                }
                return String.valueOf("Pos: null");
            }
        });
    }

    @NotNull
    protected EnergyStorageComponent<FluidTransferEntity> createEnergyStorage() {
        return new EnergyStorageComponent(0, 0, 0, -1000, -1000);
    }

    public boolean canIncrease() {
        if (this.hasConnect) {
            assert (this.f_58857_ != null);
            if (this.connectBlockPos == null) {
                return false;
            }
            if (!this.mode) {
                return false;
            }
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.connectBlockPos);
            if (blockEntity instanceof FluidTransferEntity) {
                FluidTransferEntity output;
                FluidTransferEntity input;
                FluidTransferEntity connect = (FluidTransferEntity)blockEntity;
                FluidTransferEntity self = this;
                if (self.mode == connect.mode) {
                    return false;
                }
                if (self.mode) {
                    input = self;
                    output = connect;
                } else {
                    input = connect;
                    output = self;
                }
                if (input.fluidStored.isEmpty()) {
                    return false;
                }
                if (output.fluidStored.getFluidAmount() >= output.fluidStored.getCapacity()) {
                    return false;
                }
                boolean isEmpty = output.fluidStored.isEmpty();
                return isEmpty || self.fluidStored.getFluid().isFluidEqual(connect.fluidStored.getFluid());
            }
        }
        return false;
    }

    public Runnable onFinish() {
        return () -> {
            if (this.hasConnect && this.connectBlockPos != null) {
                assert (this.f_58857_ != null);
                if (this.f_58857_.m_8055_(this.connectBlockPos).m_60734_() instanceof FluidTransferBlock) {
                    FluidTransferEntity output;
                    FluidTransferEntity input;
                    FluidTransferEntity self = this;
                    FluidTransferEntity connect = (FluidTransferEntity)this.f_58857_.m_7702_(this.connectBlockPos);
                    if (connect == null) {
                        return;
                    }
                    if (self.mode) {
                        input = self;
                        output = connect;
                    } else {
                        input = connect;
                        output = self;
                    }
                    int amount = Math.min(input.fluidStored.getFluidAmount(), this.maxTransfer);
                    FluidStack stack = new FluidStack(input.fluidStored.getFluid(), amount);
                    input.fluidStored.drainForced(stack, IFluidHandler.FluidAction.EXECUTE);
                    output.fluidStored.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        };
    }

    protected int getTickPower() {
        return 0;
    }

    @NotNull
    public FluidTransferEntity getSelf() {
        return this;
    }

    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.m_128441_("connect_block_pos")) {
            int[] temp = tag.m_128465_("connect_block_pos");
            this.connectBlockPos = new BlockPos(temp[0], temp[1], temp[2]);
        }
        if (tag.m_128441_("has_connect")) {
            this.hasConnect = tag.m_128471_("has_connect");
        }
        if (tag.m_128441_("mode")) {
            this.mode = tag.m_128471_("mode");
        }
        if (tag.m_128441_("is_fluid_render")) {
            this.isFluidRender = tag.m_128471_("is_fluid_render");
        }
        super.loadSettings(player, tag);
    }

    public void saveSettings(Player player, CompoundTag tag) {
        tag.m_128385_("connect_block_pos", new int[]{this.connectBlockPos.m_123341_(), this.connectBlockPos.m_123342_(), this.connectBlockPos.m_123343_()});
        tag.m_128379_("has_connect", this.hasConnect);
        tag.m_128379_("mode", this.mode);
        tag.m_128379_("is_fluid_render", this.isFluidRender);
        super.saveSettings(player, tag);
    }

    @Override
    public void sendBlockPos(BlockPos pos) {
        this.connectBlockPos = pos;
    }

    @Override
    public BlockPos getSendBlockPos() {
        if (this.connectBlockPos == null) {
            return null;
        }
        return this.connectBlockPos;
    }

    @Override
    public void setValue(boolean ... value) {
        this.hasConnect = value[0];
    }

    @Override
    public boolean[] getValues() {
        return new boolean[]{this.hasConnect};
    }
}

