/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.entity;

import com.buuz135.industrial.block.tile.IndustrialGeneratorTile;
import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.tile.GeneratorTile;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import org.jetbrains.annotations.NotNull;

public class CreativeCapacitorEntity
extends IndustrialGeneratorTile<CreativeCapacitorEntity> {
    @Save
    private SidedInventoryComponent<CreativeCapacitorEntity> chargingSlot;
    private final int MAX_INT_VALUE = Integer.MAX_VALUE;

    public CreativeCapacitorEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.CREATIVE_CAPACITOR, blockPos, blockState);
        this.chargingSlot = (SidedInventoryComponent)new SidedInventoryComponent("charging", 80, 40, 1, 0).setColor(DyeColor.BLUE).setSlotLimit(1).setInputFilter((stack, integer) -> stack.getCapability(ForgeCapabilities.ENERGY).isPresent());
        this.addInventory((InventoryComponent)this.chargingSlot);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, CreativeCapacitorEntity blockEntity) {
        super.serverTick(level, pos, state, (GeneratorTile)blockEntity);
        if (!this.chargingSlot.getStackInSlot(0).m_41619_()) {
            this.chargingSlot.getStackInSlot(0).getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
                if (energyStorage instanceof InfinityEnergyStorage) {
                    InfinityEnergyStorage infinityEnergyStorage = (InfinityEnergyStorage)energyStorage;
                    long added = Math.min((long)this.getEnergyStorage().getEnergyStored(), Long.MAX_VALUE - infinityEnergyStorage.getLongEnergyStored());
                    infinityEnergyStorage.setEnergyStored(infinityEnergyStorage.getLongEnergyStored() + added);
                    this.getEnergyStorage().setEnergyStored((int)((long)this.getEnergyStorage().getEnergyStored() - added));
                    this.markForUpdate();
                } else if (energyStorage.canReceive() && energyStorage.getEnergyStored() <= energyStorage.getMaxEnergyStored()) {
                    int added = energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored();
                    energyStorage.receiveEnergy(added, false);
                }
            });
        }
    }

    public int consumeFuel() {
        return Integer.MAX_VALUE;
    }

    public boolean canStart() {
        return true;
    }

    public int getEnergyProducedEveryTick() {
        if (this.getEnergyStorage().getEnergyStored() == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.getEnergyStorage().getMaxEnergyStored() - this.getEnergyStorage().getEnergyStored();
    }

    public ProgressBarComponent<CreativeCapacitorEntity> getProgressBar() {
        return new ProgressBarComponent(30, 20, 0, 15).setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
    }

    public int getEnergyCapacity() {
        return Integer.MAX_VALUE;
    }

    public int getExtractingEnergy() {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public CreativeCapacitorEntity getSelf() {
        return this;
    }
}

