/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.jei.category;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.lang.reflect.Field;
import java.util.Objects;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.yxiao233.ifeu.api.jei.AbstractJEICategory;
import net.yxiao233.ifeu.api.recipe.FluidGeneratorSerializableRecipe;
import net.yxiao233.ifeu.common.gui.AllGuiTextures;

public abstract class IFEUFluidFuelGeneratorCategory<R extends FluidGeneratorSerializableRecipe>
extends AbstractJEICategory<R> {
    private static final Component TITLE = Component.m_237113_((String)"null");
    private final IDrawable bigTank;

    public IFEUFluidFuelGeneratorCategory(IGuiHelper helper, RecipeType<R> type, Component title, Item icon) {
        super(helper, type, TITLE, icon, 95, 85);
        if (icon != null) {
            this.title = Objects.requireNonNullElseGet(title, () -> ((Item)icon).m_41466_());
        }
        this.bigTank = helper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 180, 4, 12, 50);
    }

    public abstract Class<?> getGeneratorConfigClass();

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, R recipe, IFocusGroup iFocusGroup) {
        if (((FluidGeneratorSerializableRecipe)((Object)recipe)).inputFluid != null && !((FluidGeneratorSerializableRecipe)((Object)recipe)).inputFluid.isEmpty()) {
            int maxInputTankSize;
            try {
                Field field = this.getGeneratorConfigClass().getField("maxInputTankSize");
                maxInputTankSize = field.getInt(field.getName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 19, 15).setFluidRenderer((long)Math.max(maxInputTankSize, 1000), false, 12, 50).setOverlay(this.bigTank, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)((FluidGeneratorSerializableRecipe)((Object)recipe)).inputFluid);
        }
    }

    @Override
    public void draw(R recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        EnergyBarScreenAddon.drawBackground((GuiGraphics)guiGraphics, (Screen)Minecraft.m_91087_().f_91080_, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)72, (int)12, (int)0, (int)0);
        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_NORMAL), (int)16, (int)12);
        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)IAssetProvider.getAsset((IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (IAssetType)AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_HORIZONTAL), (int)42, (int)33);
        int generated = ((FluidGeneratorSerializableRecipe)((Object)recipe)).progressTime * ((FluidGeneratorSerializableRecipe)((Object)recipe)).powerPerTick;
        EnergyBarScreenAddon.drawForeground((GuiGraphics)guiGraphics, (Screen)Minecraft.m_91087_().f_91080_, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)72, (int)12, (int)0, (int)0, (double)generated, (double)((int)Math.max(50000.0, Math.ceil(generated))));
        this.addEnergyBarTooltip(guiGraphics, this.getGeneratorConfigClass(), 18, 56, 72, 12, mouseX, mouseY);
        if (((FluidGeneratorSerializableRecipe)((Object)recipe)).isOnlyForPreview()) {
            this.drawTextureWithTooltip(guiGraphics, AllGuiTextures.JEI_INFORMATION, (Component)Component.m_237115_((String)"jei.ifeu.view.information").m_130940_(ChatFormatting.RED), 0, 66, mouseX, mouseY);
        }
    }
}

