/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.AssemblyHaloItem;

public class ManufactoryHaloItem
extends AssemblyHaloItem {
    public static final String TAG_ACTIVE = "active";
    private static final ResourceLocation glowTexture = new ResourceLocation("botania:textures/misc/glow1.png");

    public ManufactoryHaloItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int pos, boolean equipped) {
        super.m_6883_(stack, world, entity, pos, equipped);
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (!equipped && ManufactoryHaloItem.isActive(stack)) {
                for (int i = 1; i < 12; ++i) {
                    this.tryCraft(player, stack, i, false);
                }
            }
        }
    }

    @Override
    public ResourceLocation getGlowResource(ItemStack stack) {
        return ManufactoryHaloItem.isActive(stack) ? glowTexture : super.getGlowResource(stack);
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> stacks, @NotNull TooltipFlag flags) {
        if (ManufactoryHaloItem.isActive(stack)) {
            stacks.add((Component)Component.m_237115_((String)"botaniamisc.active"));
        } else {
            stacks.add((Component)Component.m_237115_((String)"botaniamisc.inactive"));
        }
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ManufactoryHaloItem.getSegmentLookedAt(stack, (LivingEntity)player) == 0 && player.m_36341_()) {
            this.togglePassive(stack, (LivingEntity)player, world);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack cursor, @NotNull Slot slot, @NotNull ClickAction click, Player player, @NotNull SlotAccess access) {
        Level world = player.m_9236_();
        if (click == ClickAction.SECONDARY && slot.m_150651_(player) && cursor.m_41619_()) {
            this.togglePassive(stack, (LivingEntity)player, world);
            access.m_142104_(cursor);
            return true;
        }
        return false;
    }

    private void togglePassive(ItemStack stack, LivingEntity living, Level world) {
        ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ManufactoryHaloItem.isActive(stack));
        if (living instanceof Player) {
            Player player = (Player)living;
            if (world != null) {
                world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.manufactoryHaloConfigure, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    private static boolean isActive(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, true);
    }
}

