/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client;

import java.util.Locale;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.BottledManaItem;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.common.item.LifeAggregatorItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.equipment.bauble.RingOfMagnetizationItem;
import vazkii.botania.common.item.equipment.tool.bow.LivingwoodBowItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraTruncatorItem;
import vazkii.botania.common.item.relic.FruitOfGrisaiaItem;
import vazkii.botania.common.item.rod.SkiesRodItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.TriConsumer;

public final class BotaniaItemProperties {
    public static void init(TriConsumer<ItemLike, ResourceLocation, ClampedItemPropertyFunction> consumer) {
        consumer.accept((ItemLike)BotaniaItems.baubleBox, ResourceLocationHelper.prefix("open"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "open", false) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.blackHoleTalisman, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "active", false) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.manaBottle, ResourceLocationHelper.prefix("swigs_taken"), (stack, world, entity, seed) -> 6 - BottledManaItem.getSwigsLeft(stack));
        ResourceLocation vuvuzelaId = ResourceLocationHelper.prefix("vuvuzela");
        ClampedItemPropertyFunction isVuvuzela = (stack, world, entity, seed) -> stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains("vuvuzela") ? 1.0f : 0.0f;
        consumer.accept((ItemLike)BotaniaItems.grassHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((ItemLike)BotaniaItems.leavesHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((ItemLike)BotaniaItems.snowHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((ItemLike)BotaniaItems.lexicon, ResourceLocationHelper.prefix("elven"), (stack, world, living, seed) -> LexicaBotaniaItem.isElven(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.manaCookie, ResourceLocationHelper.prefix("totalbiscuit"), (stack, world, entity, seed) -> stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains("totalbiscuit") ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.slimeBottle, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> stack.m_41782_() && stack.m_41783_().m_128471_("active") ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.spawnerMover, ResourceLocationHelper.prefix("full"), (stack, world, entity, seed) -> LifeAggregatorItem.hasData(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.temperanceStone, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "active", false) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.twigWand, ResourceLocationHelper.prefix("bindmode"), (stack, world, entity, seed) -> WandOfTheForestItem.getBindMode(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.dreamwoodWand, ResourceLocationHelper.prefix("bindmode"), (stack, world, entity, seed) -> WandOfTheForestItem.getBindMode(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.autocraftingHalo, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "active", true) ? 1.0f : 0.0f);
        ResourceLocation poolFullId = ResourceLocationHelper.prefix("full");
        ClampedItemPropertyFunction poolFull = (stack, world, entity, seed) -> {
            Block block = ((BlockItem)stack.m_41720_()).m_40614_();
            boolean renderFull = ((ManaPoolBlock)block).variant == ManaPoolBlock.Variant.CREATIVE || stack.m_41782_() && stack.m_41783_().m_128471_("RenderFull");
            return renderFull ? 1.0f : 0.0f;
        };
        consumer.accept((ItemLike)BotaniaBlocks.manaPool, poolFullId, poolFull);
        consumer.accept((ItemLike)BotaniaBlocks.dilutedPool, poolFullId, poolFull);
        consumer.accept((ItemLike)BotaniaBlocks.creativePool, poolFullId, poolFull);
        consumer.accept((ItemLike)BotaniaBlocks.fabulousPool, poolFullId, poolFull);
        ClampedItemPropertyFunction brewGetter = (stack, world, entity, seed) -> {
            BaseBrewItem item = (BaseBrewItem)stack.m_41720_();
            return item.getSwigs() - item.getSwigsLeft(stack);
        };
        consumer.accept((ItemLike)BotaniaItems.brewVial, ResourceLocationHelper.prefix("swigs_taken"), brewGetter);
        consumer.accept((ItemLike)BotaniaItems.brewFlask, ResourceLocationHelper.prefix("swigs_taken"), brewGetter);
        ResourceLocation holidayId = ResourceLocationHelper.prefix("holiday");
        ClampedItemPropertyFunction holidayGetter = (stack, worldIn, entityIn, seed) -> ClientProxy.jingleTheBells ? 1.0f : 0.0f;
        consumer.accept((ItemLike)BotaniaItems.manaweaveHelm, holidayId, holidayGetter);
        consumer.accept((ItemLike)BotaniaItems.manaweaveChest, holidayId, holidayGetter);
        consumer.accept((ItemLike)BotaniaItems.manaweaveBoots, holidayId, holidayGetter);
        consumer.accept((ItemLike)BotaniaItems.manaweaveLegs, holidayId, holidayGetter);
        ClampedItemPropertyFunction ringOnGetter = (stack, worldIn, entityIn, seed) -> RingOfMagnetizationItem.getCooldown(stack) <= 0 ? 1.0f : 0.0f;
        consumer.accept((ItemLike)BotaniaItems.magnetRing, ResourceLocationHelper.prefix("active"), ringOnGetter);
        consumer.accept((ItemLike)BotaniaItems.magnetRingGreater, ResourceLocationHelper.prefix("active"), ringOnGetter);
        consumer.accept((ItemLike)BotaniaItems.elementiumShears, ResourceLocationHelper.prefix("reddit"), (stack, world, entity, seed) -> stack.m_41786_().getString().equalsIgnoreCase("dammit reddit") ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.manasteelSword, ResourceLocationHelper.prefix("elucidator"), (stack, world, entity, seed) -> "the elucidator".equals(stack.m_41786_().getString().toLowerCase(Locale.ROOT).trim()) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.terraAxe, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> {
            Player player;
            return !(entity instanceof Player) || TerraTruncatorItem.shouldBreak(player = (Player)entity) ? 1 : 0;
        });
        consumer.accept((ItemLike)BotaniaItems.terraPick, ResourceLocationHelper.prefix("tipped"), (stack, world, entity, seed) -> TerraShattererItem.isTipped(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.terraPick, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> TerraShattererItem.isEnabled(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.infiniteFruit, ResourceLocationHelper.prefix("boot"), (stack, worldIn, entity, seed) -> FruitOfGrisaiaItem.isBoot(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)BotaniaItems.tornadoRod, ResourceLocationHelper.prefix("active"), (stack, world, living, seed) -> SkiesRodItem.isFlying(stack) ? 1.0f : 0.0f);
        ClampedItemPropertyFunction pulling = (stack, worldIn, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
        ClampedItemPropertyFunction pull = (stack, worldIn, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            LivingwoodBowItem item = (LivingwoodBowItem)stack.m_41720_();
            return entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) * item.chargeVelocityMultiplier() / 20.0f;
        };
        consumer.accept((ItemLike)BotaniaItems.livingwoodBow, new ResourceLocation("pulling"), pulling);
        consumer.accept((ItemLike)BotaniaItems.livingwoodBow, new ResourceLocation("pull"), pull);
        consumer.accept((ItemLike)BotaniaItems.crystalBow, new ResourceLocation("pulling"), pulling);
        consumer.accept((ItemLike)BotaniaItems.crystalBow, new ResourceLocation("pull"), pull);
    }

    private BotaniaItemProperties() {
    }
}

