/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class GuideScrollbar
extends AbstractWidget {
    private static final int WIDTH = 8;
    private int contentHeight;
    private int scrollAmount;
    private Double thumbHeldAt;

    public GuideScrollbar() {
        super(0, 0, 0, 0, (Component)Component.m_237119_());
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    protected int getMaxScrollAmount() {
        return Math.max(0, this.contentHeight - (this.f_93619_ - 4));
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        int maxScrollAmount = this.getMaxScrollAmount();
        if (maxScrollAmount <= 0) {
            return;
        }
        int thumbHeight = this.getThumbHeight();
        int left = this.m_252754_();
        int right = left + 8;
        int top = this.m_252907_() + this.getThumbTop();
        int bottom = top + thumbHeight;
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_((double)left, (double)bottom, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
        bufferBuilder.m_5483_((double)right, (double)bottom, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
        bufferBuilder.m_5483_((double)right, (double)top, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
        bufferBuilder.m_5483_((double)left, (double)top, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
        bufferBuilder.m_5483_((double)left, (double)(bottom - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
        bufferBuilder.m_5483_((double)(right - 1), (double)(bottom - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
        bufferBuilder.m_5483_((double)(right - 1), (double)top, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
        bufferBuilder.m_5483_((double)left, (double)top, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
        tesselator.m_85914_();
    }

    private int getThumbTop() {
        if (this.getMaxScrollAmount() == 0) {
            return 0;
        }
        return Math.max(0, this.scrollAmount * (this.f_93619_ - this.getThumbHeight()) / this.getMaxScrollAmount());
    }

    private int getThumbHeight() {
        if (this.contentHeight <= 0) {
            return 0;
        }
        return Mth.m_14045_((int)((int)((float)(this.f_93619_ * this.f_93619_) / (float)this.contentHeight)), (int)32, (int)this.f_93619_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean thumbHit;
        if (!this.f_93624_ || button != 0) {
            return false;
        }
        int thumbTop = this.m_252907_() + this.getThumbTop();
        int thumbBottom = thumbTop + this.getThumbHeight();
        boolean bl = thumbHit = mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + 8) && mouseY >= (double)thumbTop && mouseY < (double)thumbBottom;
        if (thumbHit) {
            this.thumbHeldAt = mouseY - (double)thumbTop;
            return true;
        }
        this.thumbHeldAt = null;
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.m_6348_(mouseX, mouseY, button);
        }
        this.thumbHeldAt = null;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.f_93624_ && this.thumbHeldAt != null) {
            int thumbY = (int)Math.round(mouseY - (double)this.m_252907_() - this.thumbHeldAt);
            int maxThumbY = this.f_93619_ - this.getThumbHeight();
            int scrollAmount = (int)Math.round((double)thumbY / (double)maxThumbY * (double)this.getMaxScrollAmount());
            this.setScrollAmount(scrollAmount);
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.f_93624_) {
            this.setScrollAmount((int)((double)this.scrollAmount - delta * 10.0));
            return true;
        }
        return false;
    }

    public void move(int x, int y, int height) {
        this.m_252865_(x);
        this.m_253211_(y);
        this.f_93618_ = 8;
        this.f_93619_ = height;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
        if (this.scrollAmount > this.getMaxScrollAmount()) {
            this.scrollAmount = this.getMaxScrollAmount();
        }
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = Mth.m_14045_((int)scrollAmount, (int)0, (int)this.getMaxScrollAmount());
    }
}

