/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.export;

import java.util.List;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RenderTypeIntrospection {
    private static final Logger LOG = LoggerFactory.getLogger(RenderTypeIntrospection.class);

    private RenderTypeIntrospection() {
    }

    public static List<Sampler> getSamplers(RenderType type) {
        if (!(type instanceof RenderType.CompositeRenderType)) {
            return List.of();
        }
        RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)type;
        RenderType.CompositeState state = compositeRenderType.m_173265_();
        RenderStateShard.EmptyTextureStateShard emptyTextureStateShard = state.f_110576_;
        if (emptyTextureStateShard instanceof RenderStateShard.TextureStateShard) {
            RenderStateShard.TextureStateShard textureShard = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
            if (textureShard.f_110328_.isPresent()) {
                ResourceLocation texture = (ResourceLocation)textureShard.f_110328_.get();
                return List.of(new Sampler(texture, textureShard.f_110329_, textureShard.f_110330_));
            }
            LOG.warn("Render type {} is using dynamic texture", (Object)type);
        } else if (state.f_110576_ != RenderStateShard.f_110147_) {
            LOG.warn("Cannot handle texturing of render-type {}", (Object)type);
        }
        return List.of();
    }

    public record Sampler(ResourceLocation texture, boolean blur, boolean mipmap) {
    }
}

