/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.tomes;

import javax.annotation.Nullable;
import net.darkhax.darkutilities.features.tomes.TomeEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ItemTome
extends Item {
    @Nullable
    private TomeEffect<Player, InteractionResultHolder<ItemStack>> userEffect;
    @Nullable
    private TomeEffect<Entity, InteractionResult> entityEffect;
    @Nullable
    private TomeEffect<BlockPos, InteractionResult> blockEffect;

    public ItemTome() {
        this(null, null, null, new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public ItemTome(@Nullable TomeEffect<Player, InteractionResultHolder<ItemStack>> userEffect, @Nullable TomeEffect<Entity, InteractionResult> entityEffect, @Nullable TomeEffect<BlockPos, InteractionResult> blockEffect) {
        this(userEffect, entityEffect, blockEffect, new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public ItemTome(@Nullable TomeEffect<Player, InteractionResultHolder<ItemStack>> userEffect, @Nullable TomeEffect<Entity, InteractionResult> entityEffect, @Nullable TomeEffect<BlockPos, InteractionResult> blockEffect, Item.Properties properties) {
        super(properties);
        this.userEffect = userEffect;
        this.entityEffect = entityEffect;
        this.blockEffect = blockEffect;
    }

    public ItemTome withUserEffect(TomeEffect<Player, InteractionResultHolder<ItemStack>> userEffect) {
        this.userEffect = userEffect;
        return this;
    }

    public ItemTome withBlockEffect(TomeEffect<BlockPos, InteractionResult> blockEffect) {
        this.blockEffect = blockEffect;
        return this;
    }

    public ItemTome withEntityEffect(TomeEffect<Entity, InteractionResult> entityEffect) {
        this.entityEffect = entityEffect;
        return this;
    }

    public InteractionResult m_6880_(ItemStack stack, Player user, LivingEntity target, InteractionHand hand) {
        InteractionResult result = null;
        if (this.entityEffect != null) {
            result = this.entityEffect.apply(stack, user, hand, (Entity)target);
        }
        return result != null ? result : super.m_6880_(stack, user, target, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = null;
        if (this.blockEffect != null) {
            result = this.blockEffect.apply(context.m_43722_(), context.m_43723_(), context.m_43724_(), context.m_8083_());
        }
        return result != null ? result : super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        InteractionResultHolder<ItemStack> result = null;
        if (this.userEffect != null) {
            result = this.userEffect.apply(player.m_21120_(hand), player, hand, player);
        }
        return result != null ? result : super.m_7203_(world, player, hand);
    }
}

