/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network;

import java.util.function.Supplier;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class TogglePerkPacket {
    private final int skillIndex;

    public TogglePerkPacket(Skill skill) {
        this.skillIndex = skill.index;
    }

    public TogglePerkPacket(FriendlyByteBuf buf) {
        this.skillIndex = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.skillIndex);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            SkillModel model = SkillModel.get((Player)player);
            if (model == null) {
                return;
            }
            Skill skill = Skill.values()[this.skillIndex];
            model.togglePerk(skill, (Player)player);
        });
        ctx.get().setPacketHandled(true);
    }
}

