/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network;

import java.util.function.Supplier;
import net.bandit.reskillable.Reskillable;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncToClient {
    private final CompoundTag skillModel;

    public SyncToClient(CompoundTag skillModel) {
        this.skillModel = skillModel;
    }

    public SyncToClient(FriendlyByteBuf buffer) {
        this.skillModel = buffer.m_130260_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.skillModel);
    }

    public static void handle(SyncToClient msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SyncToClient.handleClient(msg));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(SyncToClient msg) {
        SkillModel clientSkillModel;
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer != null && (clientSkillModel = SkillModel.get((Player)clientPlayer)) != null) {
            clientSkillModel.deserializeNBT(msg.skillModel);
        }
    }

    public static void send(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Reskillable.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncToClient(SkillModel.get(player).serializeNBT()));
        }
    }
}

