/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network;

import java.util.function.Supplier;
import net.bandit.reskillable.Reskillable;
import net.bandit.reskillable.client.Overlay;
import net.bandit.reskillable.common.commands.skills.RequirementType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class NotifyWarning {
    private final ResourceLocation resource;
    private final RequirementType type;

    public NotifyWarning(ResourceLocation resource, RequirementType type) {
        this.resource = resource;
        this.type = type;
    }

    public NotifyWarning(FriendlyByteBuf buffer) {
        this.resource = buffer.m_130281_();
        this.type = (RequirementType)buffer.m_130066_(RequirementType.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.resource);
        buffer.m_130068_((Enum)this.type);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Overlay.showWarning(this.resource, this.type);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void send(Player player, ResourceLocation resource, RequirementType type) {
        Reskillable.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new NotifyWarning(resource, type));
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        private static void handleWarning(ResourceLocation resource, RequirementType type) {
            Overlay.showWarning(resource, type);
        }
    }
}

